/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.workflow.AbstractOutputHandler;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.workflow.WorkflowItemFactory;

public class OutputHandlerFactory
extends WorkflowItemFactory {
    public static List<AbstractOutputHandler> getOutputHandlers(Workflow workflow, AntennaContext context) {
        if (workflow.getOutputHandlers() == null) {
            return Collections.emptyList();
        }
        List outputHandlerRequested = workflow.getOutputHandlers().getStep();
        return ((Stream)outputHandlerRequested.stream().parallel()).filter(rg -> Optional.ofNullable(rg.isDeactivated()).orElse(false) == false).map(rg -> {
            LOGGER.debug("Loading the {} output handler", (Object)rg.getName());
            return (AbstractOutputHandler)WorkflowItemFactory.buildWorkflowItem(rg, rg.getConfiguration(), context, rg.getWorkflowStepOrder());
        }).sorted(Comparator.comparingInt(ConfigurableWorkflowItem::getWorkflowStepOrder)).collect(Collectors.toList());
    }
}

