/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sw360.antenna.model.xml.generated.StepConfiguration;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.model.xml.generated.WorkflowStep;
import org.eclipse.sw360.antenna.util.TemplateRenderer;
import org.eclipse.sw360.antenna.util.XmlSettingsReader;
import org.eclipse.sw360.antenna.xml.XMLValidator;
import org.xml.sax.SAXException;

public class WorkflowFileLoader {
    public static Workflow loadWorkflowFromClassPath(Optional<File> workflowOverride, TemplateRenderer tr) {
        Workflow workflow = new Workflow();
        Optional<String> renderedWorkflow = tr.renderClassPathWorkflow();
        if (renderedWorkflow.isPresent()) {
            Workflow workflowFromClasspath = WorkflowFileLoader.loadRenderedWorkflow(renderedWorkflow.get());
            WorkflowFileLoader.overrideWorkflow(workflow, workflowFromClasspath);
        }
        if (workflowOverride.isPresent()) {
            WorkflowFileLoader.validateWorkflowByXSD(workflowOverride.get());
            String renderedWorkflowOverride = tr.renderTemplateFile(workflowOverride.get());
            Workflow workflowFromOverride = WorkflowFileLoader.loadRenderedWorkflow(renderedWorkflowOverride);
            WorkflowFileLoader.overrideWorkflow(workflow, workflowFromOverride);
        }
        return workflow;
    }

    public static Workflow loadRenderedWorkflow(String renderedWorkflow) {
        try {
            XmlSettingsReader workflowReader = new XmlSettingsReader(renderedWorkflow);
            return workflowReader.getComplexType("workflow", Workflow.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO exception when reading the workflow definition: " + e.getMessage());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Problem parsing the workflow definition: " + e.getMessage());
        }
    }

    public static void overrideWorkflow(Workflow workflowFromClasspath, Workflow workflowFromOverride) {
        if (workflowFromOverride.getAnalyzers() != null) {
            if (workflowFromClasspath.getAnalyzers() == null) {
                workflowFromClasspath.setAnalyzers(new Workflow.Analyzers());
            }
            WorkflowFileLoader.overrideWorkflowItems(workflowFromClasspath, workflowFromOverride, w -> w.getAnalyzers().getStep());
        }
        if (workflowFromOverride.getProcessors() != null) {
            if (workflowFromClasspath.getProcessors() == null) {
                workflowFromClasspath.setProcessors(new Workflow.Processors());
            }
            WorkflowFileLoader.overrideWorkflowItems(workflowFromClasspath, workflowFromOverride, w -> w.getProcessors().getStep());
        }
        if (workflowFromOverride.getGenerators() != null) {
            if (workflowFromClasspath.getGenerators() == null) {
                workflowFromClasspath.setGenerators(new Workflow.Generators());
            }
            WorkflowFileLoader.overrideWorkflowItems(workflowFromClasspath, workflowFromOverride, w -> w.getGenerators().getStep());
        }
        if (workflowFromOverride.getOutputHandlers() != null) {
            if (workflowFromClasspath.getOutputHandlers() == null) {
                workflowFromClasspath.setOutputHandlers(new Workflow.OutputHandlers());
            }
            WorkflowFileLoader.overrideWorkflowItems(workflowFromClasspath, workflowFromOverride, w -> w.getOutputHandlers().getStep());
        }
    }

    private static <T> void overrideWorkflowItems(Workflow workflowFromClasspath, Workflow workflowFromOverride, Function<Workflow, List<WorkflowStep>> getter) {
        List<WorkflowStep> steps = getter.apply(workflowFromClasspath);
        List<WorkflowStep> stepsOverrides = getter.apply(workflowFromOverride);
        if (stepsOverrides == null || stepsOverrides.size() == 0) {
            return;
        }
        stepsOverrides.forEach(override -> {
            Optional<WorkflowStep> actual = steps.stream().filter(a -> override.getName().equals(a.getName())).findAny();
            if (actual.isPresent()) {
                WorkflowFileLoader.overrideStep(actual.get(), override);
            } else {
                steps.add((WorkflowStep)override);
            }
        });
    }

    private static <T extends WorkflowStep> void overrideWorkflowitem(T actual, T override) {
        if (override.getClassHint() != null && !"".equals(override.getClassHint())) {
            actual.setClassHint(override.getClassHint());
        }
    }

    private static void overrideStep(WorkflowStep actual, WorkflowStep override) {
        WorkflowFileLoader.overrideWorkflowitem(actual, override);
        StepConfiguration overrideConfiguration = override.getConfiguration();
        StepConfiguration actualConfiguration = actual.getConfiguration();
        actual.setConfiguration(WorkflowFileLoader.overrideItemConfiguration(actualConfiguration, overrideConfiguration));
        actual.setDeactivated(Optional.ofNullable(override.isDeactivated()).orElse(false));
    }

    private static StepConfiguration overrideItemConfiguration(StepConfiguration actual, StepConfiguration override) {
        if (override == null) {
            return actual;
        }
        if (actual == null) {
            return override;
        }
        actual.getEntry().addAll(override.getEntry());
        return actual;
    }

    private static void validateWorkflowByXSD(File workflowOverride) {
        new XMLValidator().validateXML(workflowOverride, XmlSettingsReader.class.getClassLoader().getResource("workflow.xsd"));
    }
}

