/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow.stubs;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComplianceChecker
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComplianceChecker.class);
    private IEvaluationResult.Severity failOn;
    protected static final String FAIL_ON_KEY = "failOn";
    private Set<IEvaluationResult> evaluationResults = new HashSet<IEvaluationResult>();

    public AbstractComplianceChecker() {
        this.workflowStepOrder = (short)10000;
    }

    public abstract IPolicyEvaluation evaluate(Collection<Artifact> var1);

    public abstract String getRulesetDescription();

    public Collection<Artifact> process(Collection<Artifact> artifacts) {
        LOGGER.info("Evaluate compliance rule set: {}", (Object)this.getRulesetDescription());
        IPolicyEvaluation evaluation = this.evaluate(artifacts);
        LOGGER.debug("Rule evaluation done");
        LOGGER.debug("Check evaluation results...");
        this.execute(evaluation);
        LOGGER.debug("Check evaluation results... done.");
        return artifacts;
    }

    public WorkflowStepResult postProcessResult(WorkflowStepResult result) {
        WorkflowStepResult pResult = super.postProcessResult(result);
        if (this.evaluationResults.size() > 0) {
            pResult.addFailCausingResults(this.getWorkflowItemName(), this.evaluationResults);
        }
        return pResult;
    }

    public void configure(Map<String, String> configMap) {
        this.failOn = this.getSeverityFromConfig(FAIL_ON_KEY, configMap, IEvaluationResult.Severity.FAIL);
    }

    public void execute(IPolicyEvaluation evaluation) {
        IProcessingReporter reporter = this.context.getProcessingReporter();
        this.reportResults(reporter, evaluation.getEvaluationResults());
        Set<IEvaluationResult> failResults = this.getResults(evaluation, IEvaluationResult.Severity.FAIL);
        Set<IEvaluationResult> warnResults = this.getResults(evaluation, IEvaluationResult.Severity.WARN);
        Set<IEvaluationResult> infoResults = this.getResults(evaluation, IEvaluationResult.Severity.INFO);
        if (this.failOn == IEvaluationResult.Severity.INFO) {
            this.evaluationResults.addAll(infoResults);
            this.evaluationResults.addAll(warnResults);
            this.evaluationResults.addAll(failResults);
        } else if (this.failOn == IEvaluationResult.Severity.WARN) {
            this.evaluationResults.addAll(warnResults);
            this.evaluationResults.addAll(failResults);
        } else if (this.failOn == IEvaluationResult.Severity.FAIL) {
            this.evaluationResults.addAll(failResults);
        }
    }

    private Set<IEvaluationResult> getResults(IPolicyEvaluation evaluation, IEvaluationResult.Severity level) {
        return evaluation.getEvaluationResults().stream().filter(r -> r.getSeverity() == level && r.getFailedArtifacts().size() > 0).collect(Collectors.toSet());
    }

    private void reportResults(IProcessingReporter reporter, Set<IEvaluationResult> results) {
        results.stream().sorted(Comparator.comparing(IEvaluationResult::getId)).forEach(result -> this.reportSingleResult(reporter, (IEvaluationResult)result));
    }

    private void reportSingleResult(IProcessingReporter reporter, IEvaluationResult result) {
        String resultString = "Policy Violation: " + result.resultAsMessage();
        if (result.getSeverity().equals((Object)IEvaluationResult.Severity.FAIL)) {
            LOGGER.error(resultString);
            result.getFailedArtifacts().forEach(a -> reporter.add(MessageType.PROCESSING_FAILURE, resultString));
        } else {
            LOGGER.warn(resultString);
            result.getFailedArtifacts().forEach(a -> reporter.add(MessageType.RULE_ENGINE, resultString));
        }
    }

    protected IEvaluationResult.Severity getSeverityFromConfig(String key, Map<String, String> configMap, IEvaluationResult.Severity defaultSeverity) {
        return Optional.ofNullable(configMap.get(key)).map(IEvaluationResult.Severity::fromValue).orElse(defaultSeverity);
    }
}

