/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow.stubs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.model.artifact.Artifact;

public class DefaultPolicyEvaluation
implements IPolicyEvaluation {
    private final Set<IEvaluationResult> evaluationResults = new HashSet<IEvaluationResult>();

    public void addEvaluationResult(String ruleId, String description, IEvaluationResult.Severity severity, Artifact failedArtifact) {
        this.addEvaluationResult(new DefaultEvaluationResult(ruleId, description, severity, failedArtifact));
    }

    public void addEvaluationResult(String ruleId, String description, IEvaluationResult.Severity severity, Collection<Artifact> failedArtifacts) {
        this.addEvaluationResult(new DefaultEvaluationResult(ruleId, description, severity, failedArtifacts));
    }

    public void addEvaluationResult(IEvaluationResult iEvaluationResult) {
        this.evaluationResults.add(iEvaluationResult);
    }

    public Set<IEvaluationResult> getEvaluationResults() {
        return this.evaluationResults;
    }

    public static class DefaultEvaluationResult
    implements IEvaluationResult {
        private final String ruleId;
        private final String description;
        private final IEvaluationResult.Severity severity;
        private final Set<Artifact> failedArtifacts;

        public DefaultEvaluationResult(String ruleId, String description, IEvaluationResult.Severity severity, Artifact failedArtifact) {
            this.ruleId = ruleId;
            this.description = description;
            this.severity = severity;
            this.failedArtifacts = Collections.singleton(failedArtifact);
        }

        public DefaultEvaluationResult(String ruleId, String description, IEvaluationResult.Severity severity, Collection<Artifact> failedArtifacts) {
            this.ruleId = ruleId;
            this.description = description;
            this.severity = severity;
            this.failedArtifacts = new HashSet<Artifact>(failedArtifacts);
        }

        public String getId() {
            return this.ruleId;
        }

        public String getDescription() {
            return this.description;
        }

        public IEvaluationResult.Severity getSeverity() {
            return this.severity;
        }

        public Set<Artifact> getFailedArtifacts() {
            return this.failedArtifacts;
        }
    }
}

