/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend;

import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.IProject;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.configuration.ContextExtension;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.configuration.MultipleConfigsResolver;
import org.eclipse.sw360.antenna.core.AntennaCore;
import org.eclipse.sw360.antenna.report.Reporter;

public class AntennaFrontendHelper {
    private final IProject project;
    private ToolConfiguration toolConfig;
    private ContextExtension contextExtension = new ContextExtension();

    public AntennaFrontendHelper(IProject project) {
        this.project = project;
    }

    public AntennaFrontendHelper setToolConfiguration(ToolConfiguration toolConfig) {
        this.toolConfig = toolConfig;
        return this;
    }

    public AntennaFrontendHelper putGeneric(Object object) {
        this.contextExtension.put(object);
        return this;
    }

    public AntennaContext buildAntennaContext() {
        Reporter reporter = new Reporter(this.toolConfig.getAntennaTargetDirectory(), this.toolConfig.getEncoding());
        AntennaContext.ContextBuilder contextBuilder = new AntennaContext.ContextBuilder().setProject(this.project).setConfiguration(new MultipleConfigsResolver().resolveConfigs(this.toolConfig)).setProcessingReporter((IProcessingReporter)reporter).setToolConfiguration(this.toolConfig).setContextExtensions(this.contextExtension);
        AntennaContext context = contextBuilder.buildContext();
        boolean debug = System.getProperty("debug") != null && !"false".equals(System.getProperty("debug"));
        context.setDebug(debug);
        return context;
    }

    public AntennaCore buildAntennaCore() {
        AntennaContext context = this.buildAntennaContext();
        return this.buildAntennaCore(context);
    }

    public AntennaCore buildAntennaCore(AntennaContext context) {
        return new AntennaCore(context);
    }
}

