/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;
import org.eclipse.sw360.antenna.model.license.LicenseStatement;
import org.eclipse.sw360.antenna.model.license.WithLicense;
import org.ossreviewtoolkit.spdx.SpdxCompoundExpression;
import org.ossreviewtoolkit.spdx.SpdxException;
import org.ossreviewtoolkit.spdx.SpdxExpression;
import org.ossreviewtoolkit.spdx.SpdxLicenseIdExpression;
import org.ossreviewtoolkit.spdx.SpdxLicenseReferenceExpression;
import org.ossreviewtoolkit.spdx.SpdxLicenseWithExceptionExpression;
import org.ossreviewtoolkit.spdx.SpdxOperator;
import org.ossreviewtoolkit.spdx.SpdxSimpleExpression;

public class LicenseSupport {
    public static LicenseInformation mapLicenses(Collection<String> licenses) {
        return LicenseSupport.mapLicenses(licenses, LicenseOperator.AND);
    }

    public static LicenseInformation mapLicenses(Collection<String> licenses, LicenseOperator operator) {
        Iterator<String> iterator = licenses.iterator();
        if (!iterator.hasNext()) {
            return new License();
        }
        License license = new License();
        license.setId(iterator.next());
        if (licenses.size() == 1) {
            return license;
        }
        LicenseStatement licenseStatement = new LicenseStatement();
        licenseStatement.setOp(operator);
        licenseStatement.setLicenses((Collection)licenses.stream().map(License::new).collect(Collectors.toList()));
        return licenseStatement;
    }

    public static LicenseInformation fromSPDXExpression(String spdxExpressionString) {
        SpdxExpression spdxExpression = SpdxExpression.parse((String)spdxExpressionString);
        return LicenseSupport.fromSPDXExpression(spdxExpression);
    }

    public static LicenseInformation fromSPDXExpression(SpdxExpression spdxExpression) {
        if (spdxExpression instanceof SpdxCompoundExpression) {
            SpdxCompoundExpression spdxCompoundExpression = (SpdxCompoundExpression)spdxExpression;
            return LicenseSupport.fromSPDXCompoundExpression(spdxCompoundExpression, new LicenseStatement());
        }
        if (spdxExpression instanceof SpdxLicenseWithExceptionExpression) {
            SpdxLicenseWithExceptionExpression spdxWithExceptionExpression = (SpdxLicenseWithExceptionExpression)spdxExpression;
            return LicenseSupport.fromSpdxWithLicense(spdxWithExceptionExpression);
        }
        if (spdxExpression instanceof SpdxLicenseIdExpression) {
            SpdxLicenseIdExpression spdxLicenseIdExpression = (SpdxLicenseIdExpression)spdxExpression;
            return LicenseSupport.fromSpdxLicenseIdExpression(spdxLicenseIdExpression);
        }
        if (spdxExpression instanceof SpdxLicenseReferenceExpression) {
            SpdxLicenseReferenceExpression spdxLicenseReferenceExpression = (SpdxLicenseReferenceExpression)spdxExpression;
            return LicenseSupport.fromSpdxLicenseReferenceExpression(spdxLicenseReferenceExpression);
        }
        throw new ExecutionException("SPDX expression=[" + spdxExpression.toString() + "] could not be parsed");
    }

    public static LicenseInformation parseSpdxExpression(String expression) {
        try {
            return LicenseSupport.fromSPDXExpression(expression);
        }
        catch (SpdxException e) {
            License unparsableExpression = new License();
            unparsableExpression.setId(expression);
            return unparsableExpression;
        }
    }

    private static LicenseInformation fromSpdxWithLicense(SpdxLicenseWithExceptionExpression spdxWithExceptionExpression) {
        SpdxSimpleExpression license = spdxWithExceptionExpression.getLicense();
        String exception = spdxWithExceptionExpression.getException();
        License withLicense = (License)LicenseSupport.fromSPDXExpression((SpdxExpression)license);
        License exceptionLicense = (License)LicenseSupport.fromSPDXExpression(exception);
        return new WithLicense(withLicense.getId(), withLicense.getCommonName(), withLicense.getText(), exceptionLicense.getId(), exceptionLicense.getCommonName(), exceptionLicense.getText());
    }

    public static LicenseInformation fromSpdxLicenseReferenceExpression(SpdxLicenseReferenceExpression spdxLicenseReferenceExpression) {
        String licenseId = spdxLicenseReferenceExpression.component1();
        License license = new License();
        license.setId(licenseId);
        return license;
    }

    public static LicenseInformation fromSpdxLicenseIdExpression(SpdxLicenseIdExpression spdxLicenseIdExpression) {
        String licenseId = spdxLicenseIdExpression.component1();
        boolean isOrLater = spdxLicenseIdExpression.component2();
        if (isOrLater) {
            licenseId = licenseId + "+";
        }
        License license = new License();
        license.setId(licenseId);
        return license;
    }

    public static LicenseInformation fromSPDXCompoundExpression(SpdxCompoundExpression spdxCompoundExpression, LicenseStatement license) {
        SpdxExpression left = spdxCompoundExpression.component1();
        SpdxOperator operator = spdxCompoundExpression.component2();
        SpdxExpression right = spdxCompoundExpression.component3();
        if (SpdxOperator.AND.equals((Object)operator)) {
            license.setOp(LicenseOperator.AND);
        }
        if (SpdxOperator.OR.equals((Object)operator)) {
            license.setOp(LicenseOperator.OR);
        }
        if (left instanceof SpdxCompoundExpression) {
            LicenseSupport.checkCompoundChild((SpdxCompoundExpression)left, license);
        } else {
            license.addLicenseInformation(LicenseSupport.fromSPDXExpression(left));
        }
        if (right instanceof SpdxCompoundExpression) {
            LicenseSupport.checkCompoundChild((SpdxCompoundExpression)right, license);
        } else {
            license.addLicenseInformation(LicenseSupport.fromSPDXExpression(right));
        }
        return license;
    }

    private static LicenseInformation checkCompoundChild(SpdxCompoundExpression spdxCompoundExpression, LicenseStatement license) {
        SpdxExpression left = spdxCompoundExpression.component1();
        SpdxOperator operator = spdxCompoundExpression.component2();
        SpdxExpression right = spdxCompoundExpression.component3();
        if (operator.toString().equals(license.getOp().toString())) {
            if (left instanceof SpdxCompoundExpression) {
                LicenseSupport.checkCompoundChild((SpdxCompoundExpression)left, license);
            } else {
                license.addLicenseInformation(LicenseSupport.fromSPDXExpression(left));
            }
            if (right instanceof SpdxCompoundExpression) {
                LicenseSupport.checkCompoundChild((SpdxCompoundExpression)right, license);
            } else {
                license.addLicenseInformation(LicenseSupport.fromSPDXExpression(right));
            }
        } else {
            license.addLicenseInformation(LicenseSupport.fromSPDXExpression((SpdxExpression)spdxCompoundExpression));
        }
        return license;
    }
}

