/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.util.XmlSettingsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TemplateRenderer {
    public static final String CLASSPATH_WORKFLOW_XML = "workflow.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateRenderer.class);
    private VelocityContext renderContext = new VelocityContext();

    public TemplateRenderer() {
        System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).equals(((String)e.getKey()).toUpperCase())).forEach(e -> this.renderContext.put((String)e.getKey(), e.getValue()));
    }

    public TemplateRenderer(Map<String, Object> initMap) {
        this();
        initMap.forEach((key, value) -> this.renderContext.put(key, value));
    }

    public String renderTemplateFile(File templateFile, Map<String, Object> contextMap) {
        for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
            this.renderContext.put(entry.getKey(), entry.getValue());
        }
        return this.renderTemplateFile(templateFile);
    }

    private VelocityEngine getVelocityEngine(Map<String, String> veProperties) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        veProperties.forEach((arg_0, arg_1) -> ((VelocityEngine)ve).setProperty(arg_0, arg_1));
        return ve;
    }

    private VelocityEngine prepareVelocityEngine(File templateFile) {
        HashMap<String, String> veProperties = new HashMap<String, String>();
        veProperties.put("resource.loader", "file");
        veProperties.put("file.resource.loader.path", templateFile.getParentFile() != null ? templateFile.getParentFile().getAbsolutePath() : templateFile.getAbsoluteFile().getParentFile().getAbsolutePath());
        return this.getVelocityEngine(veProperties);
    }

    public String renderTemplateFile(File templateFile) {
        VelocityEngine ve = this.prepareVelocityEngine(templateFile);
        Template template = ve.getTemplate(templateFile.getName());
        return this.renderTemplate(template);
    }

    public Optional<String> renderClassPathWorkflow() {
        HashMap<String, String> veProperties = new HashMap<String, String>();
        veProperties.put("resource.loader", "classpath");
        veProperties.put("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        veProperties.put("classpath.resource.loader.path", "/");
        VelocityEngine ve = this.getVelocityEngine(veProperties);
        try {
            Template template = ve.getTemplate(CLASSPATH_WORKFLOW_XML);
            return Optional.of(this.renderTemplate(template));
        }
        catch (ResourceNotFoundException ex) {
            return Optional.empty();
        }
    }

    private String renderTemplateWithCurrentRenderContext(Template template) {
        StringWriter sw = new StringWriter();
        template.merge((Context)this.renderContext, (Writer)sw);
        return sw.toString();
    }

    private Map<String, String> getPropertiesMapFromRenderedResult(String result) throws IOException, SAXException, ParserConfigurationException {
        XmlSettingsReader xsr = new XmlSettingsReader(result);
        return xsr.getStringKeyedMapProperty("properties", Function.identity());
    }

    private String renderTemplate(Template template) {
        String result = this.renderTemplateWithCurrentRenderContext(template);
        try {
            Map<String, String> propertiesMap = this.getPropertiesMapFromRenderedResult(result);
            if (propertiesMap.isEmpty()) {
                return result;
            }
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                this.renderContext.put(entry.getKey(), (Object)entry.getValue());
            }
            result = this.renderTemplateWithCurrentRenderContext(template);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            String msg = "Error in second stage while rendering template. This also means that first stage result is invalid.";
            LOGGER.error(msg, (Throwable)e);
            throw new ExecutionException(msg, (Throwable)e);
        }
        return result;
    }
}

