/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.workflow.WorkflowItemFactory;

public class GeneratorFactory
extends WorkflowItemFactory {
    public static List<AbstractGenerator> getGenerators(Workflow workflow, AntennaContext context) {
        if (workflow == null) {
            throw new ConfigurationException("No <workflow> section was found in your configuration.");
        }
        if (workflow.getGenerators() == null) {
            return Collections.emptyList();
        }
        List generatorsRequested = workflow.getGenerators().getStep();
        if (generatorsRequested.size() == 0) {
            throw new ConfigurationException("No generators were found in your <workflow> section.");
        }
        return ((Stream)generatorsRequested.stream().parallel()).filter(rg -> Optional.ofNullable(rg.isDeactivated()).orElse(false) == false).map(rg -> {
            LOGGER.debug("Loading the {} generator", (Object)rg.getName());
            return (AbstractGenerator)WorkflowItemFactory.buildWorkflowItem(rg, rg.getConfiguration(), context, rg.getWorkflowStepOrder());
        }).sorted(Comparator.comparingInt(ConfigurableWorkflowItem::getWorkflowStepOrder)).collect(Collectors.toList());
    }
}

