/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.StepConfiguration;
import org.eclipse.sw360.antenna.model.xml.generated.WorkflowStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowItemFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WorkflowItemFactory.class);

    protected static <T extends ConfigurableWorkflowItem> T buildWorkflowItem(WorkflowStep wfi, StepConfiguration stepConfiguration, AntennaContext context, Short stepOrderOveride) {
        Map workflowitemConfig = Optional.ofNullable(stepConfiguration).map(StepConfiguration::getAsMap).orElse(Collections.emptyMap());
        String classHint = wfi.getClassHint().trim();
        String name = wfi.getName().trim();
        try {
            Class<?> workflowitemClazz = Class.forName(classHint);
            ConfigurableWorkflowItem instance = (ConfigurableWorkflowItem)workflowitemClazz.newInstance();
            instance.setAntennaContext(context);
            instance.overrideStepOrder(stepOrderOveride);
            instance.configure(workflowitemConfig);
            LOGGER.debug("{} loaded and configured", (Object)name);
            return (T)instance;
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionException("Could not initialize workflow item [" + name + "], because the class could not be found, reason=[" + e.getMessage() + "]", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ExecutionException("Could not initialize workflow item [" + name + "], because the class could not be instantiated, reason=[" + e.getMessage() + "]", (Throwable)e);
        }
        catch (IllegalAccessException | LinkageError | ConfigurationException e) {
            throw new ExecutionException("Could not initialize workflow item [" + name + "], reason=[" + e.getMessage() + "]", e);
        }
    }
}

