/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.validators.workflow.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIssues;
import org.eclipse.sw360.antenna.model.xml.generated.Issue;
import org.eclipse.sw360.antenna.model.xml.generated.Issues;
import org.eclipse.sw360.antenna.model.xml.generated.SecurityIssueStatus;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;
import org.eclipse.sw360.antenna.workflow.stubs.DefaultPolicyEvaluation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityIssueValidator
extends AbstractComplianceChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityIssueValidator.class);
    static final String FORBIDDEN_SECURITY_ISSUE_STATUS_SEVERITY_KEY = "forbiddenSecurityIssueStatusSeverity";
    static final String SECURITY_ISSUE_SEVERITY_LIMIT_SEVERITY_KEY = "securityIssueSeverityLimitSeverity";
    static final String FORBIDDEN_SECURITY_ISSUE_STATUSES_KEY = "forbiddenSecurityIssueStatuses";
    static final String SECURITY_ISSUE_SEVERITY_LIMIT_KEY = "securityIssueSeverityLimit";
    private static final String IGNORE_SECURITY_ISSUE_REFERENCES_KEY = "ignoreSecurityIssueReferences";
    private IEvaluationResult.Severity forbiddenSecurityIssueStatusSeverity = IEvaluationResult.Severity.FAIL;
    private List<SecurityIssueStatus> forbiddenSecurityIssueStatusesList;
    private List<String> ignoreSecurityIssueReferences;
    private double securityIssueSeverityLimit;
    private Map<ArtifactSelector, Issues> configuredSecurityIssues;
    private Map<String, Map<ArtifactSelector, GregorianCalendar>> suppressedSecurityIssues;

    public SecurityIssueValidator() {
        this.workflowStepOrder = (short)10400;
    }

    public List<IEvaluationResult> validate(Artifact artifact) {
        List<Issue> configuredIssueList = this.configuredSecurityIssues.entrySet().stream().filter(entry -> ((ArtifactSelector)entry.getKey()).matches(artifact)).map(Map.Entry::getValue).map(Issues::getIssue).flatMap(Collection::stream).collect(Collectors.toList());
        Issues issues = new Issues();
        issues.getIssue().addAll(this.mergeIssues(artifact.askForGet(ArtifactIssues.class).orElse(Collections.emptyList()), configuredIssueList));
        return new ArrayList<IEvaluationResult>(this.checkSecurityIssue(artifact, issues.getIssue()));
    }

    private List<Issue> mergeIssues(List<Issue> actualIssueList, List<Issue> configuredIssueList) {
        return Stream.concat(actualIssueList.stream(), configuredIssueList.stream()).distinct().collect(Collectors.toList());
    }

    private List<IEvaluationResult> checkSecurityIssue(Artifact artifact, List<Issue> issuesList) {
        ArrayList<IEvaluationResult> results = new ArrayList<IEvaluationResult>();
        for (Issue issue : issuesList) {
            Map<ArtifactSelector, GregorianCalendar> issueSuppressors;
            Optional<GregorianCalendar> suppressedUntil;
            if (this.ignoreSecurityIssueReferences.contains(issue.getReference())) {
                LOGGER.debug("Do not validate security issue=[{}], since it is ignored for validation", (Object)issue.getReference());
                continue;
            }
            if (this.suppressedSecurityIssues != null && this.suppressedSecurityIssues.containsKey(issue.getReference()) && (suppressedUntil = (issueSuppressors = this.suppressedSecurityIssues.get(issue.getReference())).entrySet().stream().filter(e -> ((ArtifactSelector)e.getKey()).matches(artifact)).map(Map.Entry::getValue).max(Comparator.naturalOrder())).isPresent() && new GregorianCalendar().compareTo(suppressedUntil.get()) < 0 || !this.forbiddenSecurityIssueStatusesList.contains(issue.getStatus()) || !(issue.getSeverity() >= this.securityIssueSeverityLimit)) continue;
            results.add((IEvaluationResult)new DefaultPolicyEvaluation.DefaultEvaluationResult("SecurityIssueValidator::forbiddenSecurityIssueStatus", "The artifact has a security issue [" + issue.getReference() + "] with forbidden status " + issue.getStatus() + ".", this.forbiddenSecurityIssueStatusSeverity, artifact));
        }
        return results;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        DefaultPolicyEvaluation policyEvaluation = new DefaultPolicyEvaluation();
        artifacts.stream().map(this::validate).flatMap(Collection::stream).forEach(arg_0 -> ((DefaultPolicyEvaluation)policyEvaluation).addEvaluationResult(arg_0));
        return policyEvaluation;
    }

    public String getRulesetDescription() {
        return "Security Issue Validator";
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.configuredSecurityIssues = this.context.getConfiguration().getSecurityIssues();
        this.suppressedSecurityIssues = this.context.getConfiguration().getSuppressedSecurityIssues();
        List statusStrList = this.getCommaSeparatedConfigValue(FORBIDDEN_SECURITY_ISSUE_STATUSES_KEY, configMap);
        this.forbiddenSecurityIssueStatusesList = statusStrList.stream().map(SecurityIssueStatus::fromValue).collect(Collectors.toList());
        this.forbiddenSecurityIssueStatusSeverity = this.getSeverityFromConfig(FORBIDDEN_SECURITY_ISSUE_STATUS_SEVERITY_KEY, configMap, IEvaluationResult.Severity.FAIL);
        this.securityIssueSeverityLimit = Double.valueOf(this.getConfigValue(SECURITY_ISSUE_SEVERITY_LIMIT_KEY, configMap, "0.0"));
        this.ignoreSecurityIssueReferences = this.getCommaSeparatedConfigValue(IGNORE_SECURITY_ISSUE_REFERENCES_KEY, configMap);
    }
}

