/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.validators.workflow.processors;

import java.util.Collection;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;
import org.eclipse.sw360.antenna.workflow.stubs.DefaultPolicyEvaluation;

public class CoordinatesValidator
extends AbstractComplianceChecker {
    private IEvaluationResult.Severity missingCoordinatesSeverity;

    public CoordinatesValidator() {
        this.workflowStepOrder = (short)10100;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        DefaultPolicyEvaluation policyEvaluation = new DefaultPolicyEvaluation();
        artifacts.stream().filter(artifact -> !artifact.getFlag("isProprietary")).filter(artifact -> artifact.askForAll(ArtifactCoordinates.class).size() == 0).forEach(artifact -> policyEvaluation.addEvaluationResult("CoordinatesValidator::rule1", "Artifact has no Coordinates", this.missingCoordinatesSeverity, artifact));
        return policyEvaluation;
    }

    public String getRulesetDescription() {
        return "Coordinates Validator";
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.missingCoordinatesSeverity = this.getSeverityFromConfig("failOnMissingCoordinates", configMap, IEvaluationResult.Severity.WARN);
    }
}

