/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.validators.workflow.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.util.ArtifactLicenseUtils;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;
import org.eclipse.sw360.antenna.workflow.stubs.DefaultPolicyEvaluation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseValidator
extends AbstractComplianceChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseValidator.class);
    public static final String FORBIDDEN_LICENSE_SEVERITY_KEY = "forbiddenLicenseSeverity";
    public static final String MISSING_LICENSE_INFORMATION_SEVERITY_KEY = "missingLicenseInformationSeverity";
    public static final String MISSING_LICENSE_TEXT_SEVERITY_KEY = "missingLicenseTextSeverity";
    public static final String FORBIDDEN_LICENSES_KEY = "forbiddenLicenses";
    public static final String IGNORED_LICENSES_KEY = "ignoredLicenses";
    private IEvaluationResult.Severity missingLicenseInformationSeverity = IEvaluationResult.Severity.WARN;
    private IEvaluationResult.Severity missingLicenseTextSeverity = IEvaluationResult.Severity.WARN;
    private IEvaluationResult.Severity forbiddenLicenseSeverity = IEvaluationResult.Severity.FAIL;
    private List<String> forbiddenLicenseIds;
    private List<String> ignoredLicenseIds;

    public LicenseValidator() {
        this.workflowStepOrder = (short)10200;
    }

    public List<IEvaluationResult> validate(Artifact artifact) {
        ArrayList<IEvaluationResult> results = new ArrayList<IEvaluationResult>();
        if (!artifact.getFlag("isProprietary")) {
            LicenseInformation finalLicenses = ArtifactLicenseUtils.getFinalLicenses((Artifact)artifact);
            if (finalLicenses.isEmpty()) {
                results.add((IEvaluationResult)new DefaultPolicyEvaluation.DefaultEvaluationResult("LicenseValidator::noLicense", "No License information found for the artifact.", this.missingLicenseInformationSeverity, artifact));
                return results;
            }
            for (License license : finalLicenses.getLicenses()) {
                if (this.ignoredLicenseIds.contains(license.getId())) {
                    LOGGER.debug("Do not validate license=[{}], since it is ignored for validation", (Object)license.getId());
                    continue;
                }
                if (this.forbiddenLicenseIds.contains(license.getId())) {
                    results.add((IEvaluationResult)new DefaultPolicyEvaluation.DefaultEvaluationResult("LicenseValidator::forbiddenLicense", artifact + " is licensed under the forbidden license " + license.getId(), this.forbiddenLicenseSeverity, artifact));
                }
                if (license.getText() != null && !"".equals(license.getText())) continue;
                results.add((IEvaluationResult)new DefaultPolicyEvaluation.DefaultEvaluationResult("LicenseValidator::noLicenseText", "License contains no Text", this.missingLicenseTextSeverity, artifact));
            }
        }
        return results;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        DefaultPolicyEvaluation policyEvaluation = new DefaultPolicyEvaluation();
        artifacts.stream().filter(artifact -> !artifact.getFlag("isProprietary")).forEach(artifact -> this.validate((Artifact)artifact).forEach(arg_0 -> ((DefaultPolicyEvaluation)policyEvaluation).addEvaluationResult(arg_0)));
        return policyEvaluation;
    }

    public String getRulesetDescription() {
        return "License Validator";
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.reporter = this.context.getProcessingReporter();
        this.forbiddenLicenseIds = this.getCommaSeparatedConfigValue(FORBIDDEN_LICENSES_KEY, configMap);
        this.ignoredLicenseIds = this.getCommaSeparatedConfigValue(IGNORED_LICENSES_KEY, configMap);
        this.forbiddenLicenseSeverity = this.getSeverityFromConfig(FORBIDDEN_LICENSE_SEVERITY_KEY, configMap, this.forbiddenLicenseSeverity);
        this.missingLicenseInformationSeverity = this.getSeverityFromConfig(MISSING_LICENSE_INFORMATION_SEVERITY_KEY, configMap, this.missingLicenseInformationSeverity);
        this.missingLicenseTextSeverity = this.getSeverityFromConfig(MISSING_LICENSE_TEXT_SEVERITY_KEY, configMap, this.missingLicenseTextSeverity);
    }
}

