/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.validators.workflow.processors;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactMatchingMetadata;
import org.eclipse.sw360.antenna.model.xml.generated.MatchState;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;
import org.eclipse.sw360.antenna.workflow.stubs.DefaultPolicyEvaluation;

public class MatchStateValidator
extends AbstractComplianceChecker {
    private static final String SIMILAR_SEVERITY_KEY = "severityOfSIMILAR";
    private static final String UNKNOWN_SEVERITY_KEY = "severityOfUNKNOWN";
    private IEvaluationResult.Severity SIMILAR_Severity = IEvaluationResult.Severity.WARN;
    private IEvaluationResult.Severity UNKNOWN_Severity = IEvaluationResult.Severity.WARN;

    public MatchStateValidator() {
        this.workflowStepOrder = (short)10300;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        DefaultPolicyEvaluation policyEvaluation = new DefaultPolicyEvaluation();
        artifacts.stream().filter(artifact -> !artifact.getFlag("isProprietary")).forEach(artifact -> {
            Optional artifactMatchingMetadata = artifact.askFor(ArtifactMatchingMetadata.class);
            if (!artifactMatchingMetadata.isPresent()) {
                return;
            }
            MatchState artifactsMatchState = ((ArtifactMatchingMetadata)artifactMatchingMetadata.get()).getMatchState();
            if (MatchState.SIMILAR.equals((Object)artifactsMatchState)) {
                policyEvaluation.addEvaluationResult("MatchStateValidator::rule", "The match State is SIMILAR", this.SIMILAR_Severity, artifact);
            } else if (MatchState.UNKNOWN.equals((Object)artifactsMatchState)) {
                policyEvaluation.addEvaluationResult("MatchStateValidator::rule", "The match State is UNKNOWN", this.UNKNOWN_Severity, artifact);
            }
        });
        return policyEvaluation;
    }

    public String getRulesetDescription() {
        return "Match State Validator";
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.SIMILAR_Severity = this.getSeverityFromConfig(SIMILAR_SEVERITY_KEY, configMap, this.SIMILAR_Severity);
        this.UNKNOWN_Severity = this.getSeverityFromConfig(UNKNOWN_SEVERITY_KEY, configMap, this.UNKNOWN_Severity);
    }
}

