/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.validators.workflow.processors;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;
import org.eclipse.sw360.antenna.workflow.stubs.DefaultPolicyEvaluation;

public class SourceValidator
extends AbstractComplianceChecker {
    private IProcessingReporter reporter;
    private int threshold = 80;
    private Collection<ArtifactSelector> missingSourcesWhiteList = Collections.emptySet();
    private Collection<ArtifactSelector> incompleteSourcesWhiteList = Collections.emptySet();
    private IEvaluationResult.Severity missingSourcesSeverity;
    private IEvaluationResult.Severity incompleteSourcesSeverity;

    public SourceValidator() {
        this.workflowStepOrder = (short)10500;
    }

    private boolean isArtifactAllowedToHaveNoSourceJar(Artifact artifact) {
        return this.missingSourcesWhiteList.stream().anyMatch(artifactSelector -> artifactSelector.matches(artifact));
    }

    private boolean isArtifactAllowedToHaveIncompleteSources(Artifact artifact) {
        return this.isArtifactAllowedToHaveNoSourceJar(artifact) || this.incompleteSourcesWhiteList.stream().anyMatch(artifactSelector -> artifactSelector.matches(artifact));
    }

    private List<IEvaluationResult> validateSources(Artifact artifact) {
        Optional artifactSourceFile = artifact.getSourceFile();
        if (!artifactSourceFile.isPresent()) {
            if (!this.isArtifactAllowedToHaveNoSourceJar(artifact)) {
                return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::noSourceJar", "No sources-jar available.", this.missingSourcesSeverity, artifact));
            }
            return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::noSourceJar", "Artifact has no jar sources but is handled as valid.", IEvaluationResult.Severity.INFO, artifact));
        }
        Optional artifactFile = artifact.getFile();
        if (!artifactFile.isPresent()) {
            if (!this.isArtifactAllowedToHaveIncompleteSources(artifact)) {
                return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::noJar", "The artifact has no jar. The sources thus can not be verified", this.incompleteSourcesSeverity, artifact));
            }
            return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::noJar", "Artifact has no jar to verify sources but is handled as valid.", IEvaluationResult.Severity.INFO, artifact));
        }
        if (this.isArtifactAllowedToHaveIncompleteSources(artifact)) {
            return Collections.emptyList();
        }
        try {
            return this.validateArtifactWithJars(artifact, (Path)artifactSourceFile.get(), (Path)artifactFile.get());
        }
        catch (IOException e) {
            String message = "An exception occured during source validation: " + e.getMessage();
            this.reporter.add(artifact, MessageType.PROCESSING_FAILURE, message);
            return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::noJar", message, IEvaluationResult.Severity.FAIL, artifact));
        }
    }

    private List<IEvaluationResult> validateArtifactWithJars(Artifact artifact, Path artifactSourceFile, Path artifactFile) throws IOException {
        JarFile jar = new JarFile(artifactFile.toFile());
        return this.validate(artifact, jar, artifactSourceFile.toFile());
    }

    private List<IEvaluationResult> validate(Artifact artifact, JarFile jar, File sourceJar) throws IOException {
        if (0L == sourceJar.length()) {
            return Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::jarIsEmpty", "Source jar '" + sourceJar.getName() + "' is an empty file", this.missingSourcesSeverity, artifact));
        }
        try (JarFile source = new JarFile(sourceJar);){
            ArrayList<String> missingClasses = new ArrayList<String>();
            int numberOfClassFiles = 0;
            int numberOfMatchingJavaFiles = 0;
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String name = entry.getName();
                if (!name.contains(".class") || name.contains("$")) continue;
                ++numberOfClassFiles;
                if (!this.checkIfJavaFileExists(name, source, missingClasses)) continue;
                ++numberOfMatchingJavaFiles;
            }
            if (numberOfClassFiles > 0 && numberOfMatchingJavaFiles <= numberOfClassFiles * this.threshold / 100) {
                List<DefaultPolicyEvaluation.DefaultEvaluationResult> list = Collections.singletonList(new DefaultPolicyEvaluation.DefaultEvaluationResult("SourceValidator::incompleteJar", "The sources are incomplete (only " + numberOfMatchingJavaFiles + " of " + numberOfClassFiles + " could be matched)", this.incompleteSourcesSeverity, artifact));
                return list;
            }
        }
        return Collections.emptyList();
    }

    private boolean checkIfJavaFileExists(String className, JarFile source, List<String> missingClasses) {
        JarEntry temp = source.getJarEntry(className = className.replace(".class", ".java"));
        if (null == temp) {
            missingClasses.add(className);
            return false;
        }
        return true;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        DefaultPolicyEvaluation policyEvaluation = new DefaultPolicyEvaluation();
        artifacts.stream().filter(artifact -> !artifact.getFlag("isProprietary")).filter(artifact -> artifact.getCoordinateForType("maven").isPresent()).forEach(artifact -> this.validateSources((Artifact)artifact).forEach(arg_0 -> ((DefaultPolicyEvaluation)policyEvaluation).addEvaluationResult(arg_0)));
        return policyEvaluation;
    }

    public String getRulesetDescription() {
        return "Source Validator";
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.threshold = Integer.parseInt(this.getConfigValue("threshold", configMap, "80"));
        this.missingSourcesWhiteList = this.context.getConfiguration().getValidForMissingSources();
        this.incompleteSourcesWhiteList = this.context.getConfiguration().getValidForIncompleteSources();
        String MISSING_SOURCES_KEY = "missingSourcesSeverity";
        String INCOMPLETE_SOURCES_KEY = "incompleteSourcesSeverity";
        this.missingSourcesSeverity = this.getSeverityFromConfig("missingSourcesSeverity", configMap, IEvaluationResult.Severity.FAIL);
        this.incompleteSourcesSeverity = this.getSeverityFromConfig("incompleteSourcesSeverity", configMap, IEvaluationResult.Severity.WARN);
        this.reporter = this.context.getProcessingReporter();
    }
}

