/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.adapter;

import java.util.List;
import java.util.Optional;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ComponentClient;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360SparseComponent;
import org.eclipse.sw360.antenna.sw360.utils.SW360ComponentAdapterUtils;

public class SW360ComponentClientAdapter {
    private final SW360ComponentClient componentClient;

    public SW360ComponentClientAdapter(SW360ComponentClient client) {
        this.componentClient = client;
    }

    public SW360ComponentClient getComponentClient() {
        return this.componentClient;
    }

    public Optional<SW360Component> getOrCreateComponent(SW360Component componentFromRelease) {
        if (componentFromRelease.getComponentId() != null) {
            return this.getComponentById(componentFromRelease.getComponentId());
        }
        return Optional.of(this.getComponentByName(componentFromRelease.getName()).orElseGet(() -> this.createComponent(componentFromRelease)));
    }

    public SW360Component createComponent(SW360Component component) {
        if (!SW360ComponentAdapterUtils.isValidComponent(component)) {
            throw new SW360ClientException("Can not write invalid component for " + component.getName());
        }
        return FutureUtils.block(this.getComponentClient().createComponent(component));
    }

    public Optional<SW360Component> getComponentById(String componentId) {
        return FutureUtils.block(FutureUtils.optionalFuture(this.getComponentClient().getComponent(componentId)));
    }

    public Optional<SW360Component> getComponentByName(String componentName) {
        List<SW360SparseComponent> components = FutureUtils.block(this.getComponentClient().searchByName(componentName));
        return components.stream().filter(c -> c.getName().equals(componentName)).map(c -> SW360HalResourceUtility.getLastIndexOfSelfLink(c.get_Links()).orElse("")).map(this::getComponentById).filter(Optional::isPresent).map(Optional::get).filter(c -> c.getName().equals(componentName)).findFirst();
    }

    public List<SW360SparseComponent> getComponents() {
        return FutureUtils.block(this.getComponentClient().getComponents());
    }
}

