/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.adapter;

import java.util.List;
import java.util.Optional;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360LicenseClient;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360SparseLicense;

public class SW360LicenseClientAdapter {
    private final SW360LicenseClient licenseClient;

    public SW360LicenseClientAdapter(SW360LicenseClient client) {
        this.licenseClient = client;
    }

    public SW360LicenseClient getLicenseClient() {
        return this.licenseClient;
    }

    public boolean isLicenseOfArtifactAvailable(String license) {
        List<SW360SparseLicense> sw360Licenses = FutureUtils.block(this.getLicenseClient().getLicenses());
        return sw360Licenses.stream().map(SW360SparseLicense::getShortName).anyMatch(n -> n.equals(license));
    }

    public Optional<SW360License> getSW360LicenseByAntennaLicense(String license) {
        return FutureUtils.block(FutureUtils.optionalFuture(this.getLicenseClient().getLicenseByName(license)));
    }

    public Optional<SW360License> getLicenseDetails(SW360SparseLicense sparseLicense) {
        return FutureUtils.block(FutureUtils.optionalFuture(this.getLicenseClient().getLicenseByName(sparseLicense.getShortName())));
    }
}

