/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.adapter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ProjectClient;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;
import org.eclipse.sw360.antenna.sw360.rest.resource.LinkObjects;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.rest.resource.Self;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.antenna.sw360.utils.SW360ProjectAdapterUtils;

public class SW360ProjectClientAdapter {
    private final SW360ProjectClient projectClient;

    public SW360ProjectClientAdapter(SW360ProjectClient client) {
        this.projectClient = client;
    }

    public SW360ProjectClient getProjectClient() {
        return this.projectClient;
    }

    public Optional<String> getProjectIdByNameAndVersion(String projectName, String projectVersion) {
        List<SW360Project> projects = FutureUtils.block(this.getProjectClient().searchByName(projectName));
        return projects.stream().filter(pr -> SW360ProjectAdapterUtils.hasEqualCoordinates(pr, projectName, projectVersion)).findAny().map(SW360HalResource::get_Links).flatMap(SW360HalResourceUtility::getLastIndexOfSelfLink);
    }

    public String addProject(String projectName, String projectVersion) {
        SW360Project sw360Project = new SW360Project();
        SW360ProjectAdapterUtils.prepareProject(sw360Project, projectName, projectVersion);
        if (!SW360ProjectAdapterUtils.isValidProject(sw360Project)) {
            throw new SW360ClientException("Can not write invalid project with name=" + projectName + " and version=" + projectVersion);
        }
        SW360Project responseProject = FutureUtils.block(this.getProjectClient().createProject(sw360Project));
        return SW360HalResourceUtility.getLastIndexOfSelfLink(responseProject.get_Links()).orElse("");
    }

    public void addSW360ReleasesToSW360Project(String id, Collection<SW360Release> releases) {
        List<String> releaseLinks = releases.stream().map(SW360HalResource::get_Links).filter(Objects::nonNull).map(LinkObjects::getSelf).filter(Objects::nonNull).map(Self::getHref).collect(Collectors.toList());
        this.getProjectClient().addReleasesToProject(id, releaseLinks);
    }

    public List<SW360SparseRelease> getLinkedReleases(String projectId) {
        return FutureUtils.block(this.getProjectClient().getLinkedReleases(projectId, true));
    }
}

