/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.adapter;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ComponentClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ReleaseClient;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360ComponentEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseLinkObjects;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.antenna.sw360.utils.SW360ComponentAdapterUtils;
import org.eclipse.sw360.antenna.sw360.utils.SW360ReleaseAdapterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360ReleaseClientAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360ReleaseClientAdapter.class);
    private final SW360ReleaseClient releaseClient;
    private final SW360ComponentClientAdapter sw360ComponentClientAdapter;

    public SW360ReleaseClientAdapter(SW360ReleaseClient client, SW360ComponentClientAdapter componentClientAdapter) {
        this.releaseClient = client;
        this.sw360ComponentClientAdapter = componentClientAdapter;
    }

    public SW360ReleaseClient getReleaseClient() {
        return this.releaseClient;
    }

    public SW360ComponentClientAdapter getComponentAdapter() {
        return this.sw360ComponentClientAdapter;
    }

    public SW360Release getOrCreateRelease(SW360Release sw360ReleaseFromArtifact, boolean updateReleases) {
        return this.getRelease(sw360ReleaseFromArtifact).map(sw360ReleaseFromArtifact::mergeWith).map(sw360Release -> {
            if (updateReleases) {
                return FutureUtils.block(this.getReleaseClient().patchRelease((SW360Release)sw360Release));
            }
            return sw360Release;
        }).orElseGet(() -> this.createRelease(sw360ReleaseFromArtifact));
    }

    public SW360Release createRelease(SW360Release releaseFromArtifact) {
        if (!SW360ReleaseAdapterUtils.isValidRelease(releaseFromArtifact)) {
            throw new SW360ClientException("Can not write invalid release for " + releaseFromArtifact.getName() + "-" + releaseFromArtifact.getVersion());
        }
        if (releaseFromArtifact.getReleaseId() != null) {
            throw new SW360ClientException("Can not write release which already has the id " + releaseFromArtifact.getReleaseId());
        }
        if (releaseFromArtifact.getComponentId() == null) {
            SW360Component componentFromRelease = SW360ComponentAdapterUtils.createFromRelease(releaseFromArtifact);
            Optional<SW360Component> componentFromSW360 = this.getComponentAdapter().getOrCreateComponent(componentFromRelease);
            componentFromSW360.ifPresent(cfs -> {
                if (((SW360ComponentEmbedded)cfs.get_Embedded()).getReleases().stream().map(SW360SparseRelease::getVersion).anyMatch(releaseFromArtifact.getVersion()::equals)) {
                    throw new SW360ClientException("The release already exists in the found component");
                }
                releaseFromArtifact.setComponentId(cfs.getComponentId());
            });
        }
        return FutureUtils.block(this.getReleaseClient().createRelease(releaseFromArtifact));
    }

    public SW360Release uploadAttachments(SW360Release sw360item, Map<Path, SW360AttachmentType> attachments) {
        for (Map.Entry<Path, SW360AttachmentType> attachment : attachments.entrySet()) {
            if (this.attachmentIsPotentialDuplicate(attachment.getKey(), ((SW360ReleaseEmbedded)sw360item.get_Embedded()).getAttachments())) continue;
            sw360item = FutureUtils.block(this.getReleaseClient().uploadAndAttachAttachment(sw360item, attachment.getKey(), attachment.getValue()));
        }
        return sw360item;
    }

    private boolean attachmentIsPotentialDuplicate(Path attachment, List<SW360SparseAttachment> attachments) {
        return attachments.stream().anyMatch(attachment1 -> attachment1.getFilename().equals(attachment.getFileName().toString()));
    }

    public Optional<SW360Release> getReleaseById(String releaseId) {
        return FutureUtils.block(FutureUtils.optionalFuture(this.getReleaseClient().getRelease(releaseId)));
    }

    public Optional<SW360Release> enrichSparseRelease(SW360SparseRelease sparseRelease) {
        return this.getReleaseById(sparseRelease.getReleaseId());
    }

    public Optional<SW360SparseRelease> getSparseRelease(SW360Release sw360ReleaseFromArtifact) {
        Optional<SW360SparseRelease> releaseByExternalId = this.getReleaseByExternalIds(sw360ReleaseFromArtifact.getExternalIds());
        if (releaseByExternalId.isPresent()) {
            return releaseByExternalId;
        }
        return this.getReleaseByNameAndVersion(sw360ReleaseFromArtifact);
    }

    public Optional<SW360Release> getRelease(SW360Release sw360ReleaseFromArtifact) {
        return this.getSparseRelease(sw360ReleaseFromArtifact).map(this::enrichSparseRelease).filter(Optional::isPresent).map(Optional::get);
    }

    public Optional<SW360SparseRelease> getReleaseByExternalIds(Map<String, ?> externalIds) {
        List<SW360SparseRelease> releasesByExternalIds = FutureUtils.block(this.getReleaseClient().getReleasesByExternalIds(externalIds));
        if (releasesByExternalIds.isEmpty()) {
            return Optional.empty();
        }
        if (releasesByExternalIds.size() == 1) {
            return Optional.of(releasesByExternalIds.get(0));
        }
        LOGGER.error("Multiple releases in SW360 matched by externalIDs");
        return Optional.empty();
    }

    public Optional<SW360SparseRelease> getReleaseByNameAndVersion(SW360Release sw360ReleaseFromArtifact) {
        return this.getComponentAdapter().getComponentByName(sw360ReleaseFromArtifact.getName()).map(SW360HalResource::get_Embedded).map(SW360ComponentEmbedded::getReleases).flatMap(releases -> releases.stream().filter(release -> sw360ReleaseFromArtifact.getVersion().equals(release.getVersion())).findFirst());
    }

    public Optional<SW360Release> getReleaseByVersion(SW360Component component, String releaseVersion) {
        List<SW360SparseRelease> releases;
        Optional releaseId;
        if (component != null && component.get_Embedded() != null && ((SW360ComponentEmbedded)component.get_Embedded()).getReleases() != null && (releaseId = (releases = ((SW360ComponentEmbedded)component.get_Embedded()).getReleases()).stream().filter(release -> release.getVersion().equals(releaseVersion)).findFirst().flatMap(release -> SW360HalResourceUtility.getLastIndexOfSelfLink(release.get_Links()))).isPresent()) {
            return this.getReleaseById((String)releaseId.get());
        }
        return Optional.empty();
    }

    public Optional<Path> downloadAttachment(SW360Release release, SW360SparseAttachment attachment, Path downloadPath) {
        return Optional.ofNullable(((SW360ReleaseLinkObjects)release.get_Links()).getSelf()).flatMap(self -> FutureUtils.block(FutureUtils.optionalFuture(this.getReleaseClient().downloadAttachment(self.getHref(), attachment, downloadPath))));
    }
}

