/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client;

import org.eclipse.sw360.antenna.sw360.adapter.SW360ComponentClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.api.SW360Connection;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.auth.SW360AuthenticationClient;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ComponentClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360LicenseClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ProjectClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ReleaseClient;

public class SW360ConnectionFactory {
    public SW360Connection newConnection(SW360ClientConfig config) {
        SW360AuthenticationClient authClient = new SW360AuthenticationClient(config);
        AccessTokenProvider tokenProvider = new AccessTokenProvider(authClient);
        SW360ComponentClient componentClient = new SW360ComponentClient(config, tokenProvider);
        final SW360ComponentClientAdapter componentAdapter = new SW360ComponentClientAdapter(componentClient);
        SW360ReleaseClient releaseClient = new SW360ReleaseClient(config, tokenProvider);
        final SW360ReleaseClientAdapter releaseAdapter = new SW360ReleaseClientAdapter(releaseClient, componentAdapter);
        SW360LicenseClient licenseClient = new SW360LicenseClient(config, tokenProvider);
        final SW360LicenseClientAdapter licenseAdapter = new SW360LicenseClientAdapter(licenseClient);
        SW360ProjectClient projectClient = new SW360ProjectClient(config, tokenProvider);
        final SW360ProjectClientAdapter projectAdapter = new SW360ProjectClientAdapter(projectClient);
        return new SW360Connection(){

            @Override
            public SW360ComponentClientAdapter getComponentAdapter() {
                return componentAdapter;
            }

            @Override
            public SW360ReleaseClientAdapter getReleaseAdapter() {
                return releaseAdapter;
            }

            @Override
            public SW360LicenseClientAdapter getLicenseAdapter() {
                return licenseAdapter;
            }

            @Override
            public SW360ProjectClientAdapter getProjectAdapter() {
                return projectAdapter;
            }
        };
    }
}

