/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.ResponseProcessor;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SW360Client {
    private static final Logger LOG = LoggerFactory.getLogger(SW360Client.class);
    private final SW360ClientConfig clientConfig;
    private final AccessTokenProvider tokenProvider;

    protected SW360Client(SW360ClientConfig config, AccessTokenProvider tokenProvider) {
        this.clientConfig = config;
        this.tokenProvider = tokenProvider;
    }

    public SW360ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public AccessTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    protected <T> CompletableFuture<T> executeRequest(Consumer<? super RequestBuilder> producer, ResponseProcessor<T> processor, String tag) {
        return this.manageTokenAndExecute(producer, processor, tag, true);
    }

    protected <T> CompletableFuture<T> executeJsonRequest(Consumer<? super RequestBuilder> producer, Class<T> resultClass, String tag) {
        return this.executeRequest(producer, HttpUtils.jsonResult((ObjectMapper)this.getClientConfig().getObjectMapper(), resultClass), tag);
    }

    protected String resourceUrl(String ... paths) {
        return this.getClientConfig().getRestURL() + "/" + String.join((CharSequence)"/", paths);
    }

    private <T> CompletableFuture<T> manageTokenAndExecute(Consumer<? super RequestBuilder> producer, ResponseProcessor<T> processor, String tag, boolean canRetry) {
        LOG.debug("Executing request '{}'{}.", (Object)tag, (Object)(canRetry ? "" : " (retry)"));
        CompletableFuture futRequest = this.getTokenProvider().doWithToken(accessToken -> this.getClientConfig().getHttpClient().execute(accessToken.tokenProducer(producer), HttpUtils.checkResponse((ResponseProcessor)processor, (String)tag)));
        return canRetry ? FutureUtils.wrapFutureForConditionalFallback(futRequest, this::checkIfRetry, () -> this.manageTokenAndExecute(producer, processor, tag, false)) : futRequest;
    }

    private boolean checkIfRetry(Throwable exception) {
        return FutureUtils.isFailedRequestWithStatus(exception, 401);
    }
}

