/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360Client;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ResourceUtils;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360ProjectList;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseList;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360SparseRelease;

public class SW360ProjectClient
extends SW360Client {
    static final String TAG_GET_BY_NAME = "get_projects_by_name";
    static final String TAG_CREATE_PROJECT = "post_create_project";
    static final String TAG_ADD_RELEASES_TO_PROJECT = "post_add_releases_to_project";
    static final String TAG_GET_LINKED_RELEASES = "get_releases_linked_to_project";
    private static final String PROJECTS_ENDPOINT = "projects";

    public SW360ProjectClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<List<SW360Project>> searchByName(String name) {
        String queryUrl = HttpUtils.addQueryParameter((String)this.resourceUrl(PROJECTS_ENDPOINT), (String)"name", (Object)name);
        return this.executeJsonRequest(HttpUtils.get((String)queryUrl), SW360ProjectList.class, TAG_GET_BY_NAME).thenApply(SW360ResourceUtils::getSw360Projects);
    }

    public CompletableFuture<SW360Project> createProject(SW360Project sw360Project) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(PROJECTS_ENDPOINT)).body(body -> body.json((Object)sw360Project)), SW360Project.class, TAG_CREATE_PROJECT);
    }

    public CompletableFuture<Void> addReleasesToProject(String projectId, List<String> releases) {
        return this.executeRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(PROJECTS_ENDPOINT, projectId, "releases")).body(body -> body.json((Object)releases)), HttpUtils.nullProcessor(), TAG_ADD_RELEASES_TO_PROJECT);
    }

    public CompletableFuture<List<SW360SparseRelease>> getLinkedReleases(String projectId, boolean transitive) {
        String uri = HttpUtils.addQueryParameter((String)this.resourceUrl(PROJECTS_ENDPOINT, projectId, "releases"), (String)"transitive", (Object)transitive);
        return this.executeJsonRequest(HttpUtils.get((String)uri), SW360ReleaseList.class, TAG_GET_LINKED_RELEASES).thenApply(SW360ResourceUtils::getSw360SparseReleases);
    }
}

