/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.sw360.antenna.sw360.rest.resource.Embedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360ComponentList;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360ComponentListEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360SparseComponent;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360LicenseList;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360LicenseListEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360ProjectList;
import org.eclipse.sw360.antenna.sw360.rest.resource.projects.SW360ProjectListEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseList;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseListEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360SparseRelease;

public class SW360ResourceUtils {
    private SW360ResourceUtils() {
    }

    public static List<SW360SparseLicense> getSw360SparseLicenses(SW360LicenseList response) {
        return SW360ResourceUtils.extractEmbeddedList(response, SW360ResourceUtils::extractSparseLicenseList);
    }

    public static List<SW360Project> getSw360Projects(SW360ProjectList response) {
        return SW360ResourceUtils.extractEmbeddedList(response, SW360ProjectListEmbedded::getProjects);
    }

    public static List<SW360SparseRelease> getSw360SparseReleases(SW360ReleaseList response) {
        return SW360ResourceUtils.extractEmbeddedList(response, SW360ReleaseListEmbedded::getReleases);
    }

    public static List<SW360SparseComponent> getSw360SparseComponents(SW360ComponentList response) {
        return SW360ResourceUtils.extractEmbeddedList(response, SW360ComponentListEmbedded::getComponents);
    }

    private static List<SW360SparseLicense> extractSparseLicenseList(SW360LicenseListEmbedded embeddedLicenses) {
        return Optional.ofNullable(embeddedLicenses.getLicenses()).map(ArrayList::new).orElse(null);
    }

    private static <E extends Embedded, T extends SW360HalResource<?, E>, U> List<U> extractEmbeddedList(T resource, Function<E, List<U>> extractor) {
        return Optional.ofNullable(resource.get_Embedded()).flatMap(embedded -> Optional.ofNullable(extractor.apply(embedded)).map(ArrayList::new)).orElseGet(ArrayList::new);
    }
}

