/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.rest.resource.components;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.sw360.rest.resource.LinkObjects;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360ComponentEmbedded;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360ComponentType;

public class SW360Component
extends SW360HalResource<LinkObjects, SW360ComponentEmbedded> {
    private String name;
    private SW360ComponentType componentType;
    private String createdOn;
    private String homepage;

    @JsonIgnore
    public String getComponentId() {
        return Optional.ofNullable(this.get_Links()).map(LinkObjects::getSelf).flatMap(SW360HalResourceUtility::getLastIndexOfSelfLink).orElse(null);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    public SW360Component setName(String name) {
        this.name = name;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedOn() {
        return this.createdOn;
    }

    public SW360Component setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SW360ComponentType getComponentType() {
        return this.componentType;
    }

    public SW360Component setComponentType(SW360ComponentType componentType) {
        this.componentType = componentType;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHomepage() {
        return this.homepage;
    }

    public SW360Component setHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    @Override
    public LinkObjects createEmptyLinks() {
        return new LinkObjects();
    }

    @Override
    public SW360ComponentEmbedded createEmptyEmbedded() {
        return new SW360ComponentEmbedded();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SW360Component that = (SW360Component)o;
        return Objects.equals(this.name, that.name) && this.componentType == that.componentType && Objects.equals(this.createdOn, that.createdOn) && Objects.equals(this.homepage, that.homepage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, this.componentType, this.createdOn, this.homepage});
    }
}

