/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360LicenseClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;

class SW360LicenseClientAdapterAsyncImpl
implements SW360LicenseClientAdapterAsync {
    private final SW360LicenseClient licenseClient;

    public SW360LicenseClientAdapterAsyncImpl(SW360LicenseClient client) {
        this.licenseClient = client;
    }

    @Override
    public SW360LicenseClient getLicenseClient() {
        return this.licenseClient;
    }

    @Override
    public CompletableFuture<Boolean> isLicenseOfArtifactAvailable(String license) {
        return this.getLicenseClient().getLicenses().thenApply(sw360Licenses -> sw360Licenses.stream().map(SW360SparseLicense::getShortName).anyMatch(n -> n.equals(license)));
    }

    @Override
    public CompletableFuture<Optional<SW360License>> getSW360LicenseByAntennaLicense(String license) {
        return FutureUtils.optionalFuture(this.getLicenseClient().getLicenseByName(license));
    }

    @Override
    public CompletableFuture<Optional<SW360License>> getLicenseDetails(SW360SparseLicense sparseLicense) {
        return FutureUtils.optionalFuture(this.getLicenseClient().getLicenseByName(sparseLicense.getShortName()));
    }
}

