/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360Visibility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360ProjectType;

class SW360ProjectAdapterUtils {
    private SW360ProjectAdapterUtils() {
    }

    public static void setDescription(SW360Project project, String mvnDescription) {
        if (StringUtils.isNotEmpty((CharSequence)mvnDescription)) {
            project.setDescription(mvnDescription);
        }
    }

    public static void setName(SW360Project project, String applicationId) {
        if (applicationId != null && !applicationId.isEmpty()) {
            project.setName(applicationId);
        }
    }

    public static void setVersion(SW360Project project, String version) {
        if (version != null && !version.isEmpty()) {
            project.setVersion(version);
        }
    }

    public static void prepareProject(SW360Project sw360Project, String projectName, String projectVersion) {
        SW360ProjectAdapterUtils.setName(sw360Project, projectName);
        SW360ProjectAdapterUtils.setVersion(sw360Project, projectVersion);
        SW360ProjectAdapterUtils.setDescription(sw360Project, projectName + " " + projectVersion);
        sw360Project.setProjectType(SW360ProjectType.PRODUCT);
        sw360Project.setVisibility(SW360Visibility.BUISNESSUNIT_AND_MODERATORS);
    }

    public static boolean isValidProject(SW360Project project) {
        return StringUtils.isNotEmpty((CharSequence)project.getName()) && StringUtils.isNotEmpty((CharSequence)project.getVersion());
    }

    public static boolean hasEqualCoordinates(SW360Project sw360Project, String projectName, String projectVersion) {
        boolean isAppIdEqual = sw360Project.getName().equalsIgnoreCase(projectName);
        boolean isProjectVersionEqual = sw360Project.getVersion().equalsIgnoreCase(projectVersion);
        return isAppIdEqual && isProjectVersionEqual;
    }
}

