/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ProjectClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.LinkObjects;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.Self;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

class SW360ProjectClientAdapterAsyncImpl
implements SW360ProjectClientAdapterAsync {
    private final SW360ProjectClient projectClient;

    public SW360ProjectClientAdapterAsyncImpl(SW360ProjectClient client) {
        this.projectClient = client;
    }

    @Override
    public SW360ProjectClient getProjectClient() {
        return this.projectClient;
    }

    @Override
    public CompletableFuture<Optional<String>> getProjectIdByNameAndVersion(String projectName, String projectVersion) {
        return this.getProjectClient().searchByName(projectName).thenApply(projects -> projects.stream().filter(pr -> SW360ProjectAdapterUtils.hasEqualCoordinates(pr, projectName, projectVersion)).findAny().map(SW360HalResource::getLinks).flatMap(SW360HalResourceUtility::getLastIndexOfSelfLink));
    }

    @Override
    public CompletableFuture<String> addProject(String projectName, String projectVersion) {
        SW360Project sw360Project = new SW360Project();
        SW360ProjectAdapterUtils.prepareProject(sw360Project, projectName, projectVersion);
        if (!SW360ProjectAdapterUtils.isValidProject(sw360Project)) {
            SW360ClientException exception = new SW360ClientException("Can not write invalid project with name=" + projectName + " and version=" + projectVersion);
            return FutureUtils.failedFuture(exception);
        }
        return this.getProjectClient().createProject(sw360Project).thenApply(responseProject -> SW360HalResourceUtility.getLastIndexOfSelfLink(responseProject.getLinks()).orElse(""));
    }

    @Override
    public CompletableFuture<Void> addSW360ReleasesToSW360Project(String id, Collection<SW360Release> releases) {
        List<String> releaseLinks = releases.stream().map(SW360HalResource::getLinks).filter(Objects::nonNull).map(LinkObjects::getSelf).filter(Objects::nonNull).map(Self::getHref).collect(Collectors.toList());
        return this.getProjectClient().addReleasesToProject(id, releaseLinks);
    }

    @Override
    public CompletableFuture<List<SW360SparseRelease>> getLinkedReleases(String projectId) {
        return this.getProjectClient().getLinkedReleases(projectId, true);
    }
}

