/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ReleaseClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360ComponentEmbedded;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseLinkObjects;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

class SW360ReleaseClientAdapterAsyncImpl
implements SW360ReleaseClientAdapterAsync {
    private final SW360ReleaseClient releaseClient;
    private final SW360ComponentClientAdapterAsync sw360ComponentClientAdapter;

    public SW360ReleaseClientAdapterAsyncImpl(SW360ReleaseClient client, SW360ComponentClientAdapterAsync componentClientAdapter) {
        this.releaseClient = client;
        this.sw360ComponentClientAdapter = componentClientAdapter;
    }

    @Override
    public SW360ReleaseClient getReleaseClient() {
        return this.releaseClient;
    }

    public SW360ComponentClientAdapterAsync getComponentAdapter() {
        return this.sw360ComponentClientAdapter;
    }

    @Override
    public CompletableFuture<SW360Release> getOrCreateRelease(SW360Release sw360ReleaseFromArtifact, boolean updateReleases) {
        return ((CompletableFuture)((CompletableFuture)this.getRelease(sw360ReleaseFromArtifact).thenApply(optRelease -> optRelease.map(sw360ReleaseFromArtifact::mergeWith))).thenCompose(optRelease -> {
            if (updateReleases && optRelease.isPresent()) {
                return this.getReleaseClient().patchRelease((SW360Release)optRelease.get()).thenApply(Optional::of);
            }
            return CompletableFuture.completedFuture(optRelease);
        })).thenCompose(optRelease -> optRelease.map(CompletableFuture::completedFuture).orElseGet(() -> this.createRelease(sw360ReleaseFromArtifact)));
    }

    @Override
    public CompletableFuture<SW360Release> createRelease(SW360Release releaseFromArtifact) {
        if (!SW360ReleaseAdapterUtils.isValidRelease(releaseFromArtifact)) {
            return FutureUtils.failedFuture(new SW360ClientException("Can not write invalid release for " + releaseFromArtifact.getName() + "-" + releaseFromArtifact.getVersion()));
        }
        if (releaseFromArtifact.getId() != null) {
            throw new SW360ClientException("Can not write release which already has the id " + releaseFromArtifact.getId());
        }
        return this.assignReleaseToComponent(releaseFromArtifact).thenCompose(this.getReleaseClient()::createRelease);
    }

    private CompletableFuture<SW360Release> assignReleaseToComponent(SW360Release release) {
        SW360Component componentFromRelease = SW360ComponentAdapterUtils.createFromRelease(release);
        return this.getComponentAdapter().getOrCreateComponent(componentFromRelease).thenApply(componentFromSW360 -> {
            componentFromSW360.ifPresent(cfs -> {
                if (((SW360ComponentEmbedded)cfs.getEmbedded()).getReleases().stream().map(SW360SparseRelease::getVersion).anyMatch(release.getVersion()::equals)) {
                    throw new SW360ClientException("The release already exists in the found component");
                }
                release.setComponentId(cfs.getId());
            });
            return release;
        });
    }

    @Override
    public CompletableFuture<SW360Release> uploadAttachments(SW360Release sw360item, Map<Path, SW360AttachmentType> attachments) {
        CompletionStage<SW360Release> futUpdatedRelease = CompletableFuture.completedFuture(sw360item);
        for (Map.Entry<Path, SW360AttachmentType> attachment : attachments.entrySet()) {
            if (SW360ReleaseClientAdapterAsyncImpl.attachmentIsPotentialDuplicate(attachment.getKey(), ((SW360ReleaseEmbedded)sw360item.getEmbedded()).getAttachments())) continue;
            futUpdatedRelease = futUpdatedRelease.thenCompose(release -> this.getReleaseClient().uploadAndAttachAttachment(sw360item, (Path)attachment.getKey(), (SW360AttachmentType)((Object)((Object)attachment.getValue()))));
        }
        return futUpdatedRelease;
    }

    private static boolean attachmentIsPotentialDuplicate(Path attachment, Set<SW360SparseAttachment> attachments) {
        return attachments.stream().anyMatch(attachment1 -> attachment1.getFilename().equals(attachment.getFileName().toString()));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> getReleaseById(String releaseId) {
        return FutureUtils.optionalFuture(this.getReleaseClient().getRelease(releaseId));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> enrichSparseRelease(SW360SparseRelease sparseRelease) {
        return this.getReleaseById(sparseRelease.getReleaseId());
    }

    @Override
    public CompletableFuture<Optional<SW360SparseRelease>> getSparseRelease(SW360Release release) {
        return this.getReleaseByExternalIds(release.getExternalIds()).thenCompose(optRelease -> optRelease.map(rel -> CompletableFuture.completedFuture(Optional.of(rel))).orElseGet(() -> this.getReleaseByNameAndVersion(release)));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> getRelease(SW360Release sw360ReleaseFromArtifact) {
        return this.getSparseRelease(sw360ReleaseFromArtifact).thenCompose(optRelease -> optRelease.map(this::enrichSparseRelease).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())));
    }

    @Override
    public CompletableFuture<Optional<SW360SparseRelease>> getReleaseByExternalIds(Map<String, ?> externalIds) {
        return this.getReleaseClient().getReleasesByExternalIds(externalIds).thenApply(releases -> {
            if (releases.isEmpty()) {
                return Optional.empty();
            }
            if (releases.size() == 1) {
                return Optional.of(releases.get(0));
            }
            throw new SW360ClientException("Multiple releases in SW360 matched by externalIDs: " + externalIds);
        });
    }

    @Override
    public CompletableFuture<Optional<SW360SparseRelease>> getReleaseByNameAndVersion(SW360Release release) {
        return this.getComponentAdapter().getComponentByName(release.getName()).thenApply(optComponent -> optComponent.map(SW360HalResource::getEmbedded).map(SW360ComponentEmbedded::getReleases).flatMap(releases -> releases.stream().filter(rel -> release.getVersion().equals(rel.getVersion())).findFirst()));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> getReleaseByVersion(SW360Component component, String releaseVersion) {
        List<SW360SparseRelease> releases;
        Optional releaseId;
        if (component != null && component.getEmbedded() != null && ((SW360ComponentEmbedded)component.getEmbedded()).getReleases() != null && (releaseId = (releases = ((SW360ComponentEmbedded)component.getEmbedded()).getReleases()).stream().filter(release -> release.getVersion().equals(releaseVersion)).findFirst().flatMap(release -> SW360HalResourceUtility.getLastIndexOfSelfLink(release.getLinks()))).isPresent()) {
            return this.getReleaseById((String)releaseId.get());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<Path>> downloadAttachment(SW360Release release, SW360SparseAttachment attachment, Path downloadPath) {
        return Optional.ofNullable(((SW360ReleaseLinkObjects)release.getLinks()).getSelf()).map(self -> FutureUtils.optionalFuture(this.getReleaseClient().downloadAttachment(self.getHref(), attachment, downloadPath))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }
}

