/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360Client;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360LicenseList;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ResourceUtils;

public class SW360LicenseClient
extends SW360Client {
    static final String TAG_GET_LICENSES = "get_licenses";
    static final String TAG_GET_LICENSE_BY_NAME = "get_license_by_name";
    private static final String LICENSES_ENDPOINT = "licenses";

    public SW360LicenseClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<List<SW360SparseLicense>> getLicenses() {
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)this.resourceUrl(LICENSES_ENDPOINT)), SW360LicenseList.class, TAG_GET_LICENSES, SW360LicenseList::new).thenApply(SW360ResourceUtils::getSw360SparseLicenses);
    }

    public CompletableFuture<SW360License> getLicenseByName(String name) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(LICENSES_ENDPOINT, name)), SW360License.class, TAG_GET_LICENSE_BY_NAME);
    }
}

