/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.utils;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.sw360.antenna.http.utils.FailedRequestException;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

public class FutureUtils {
    private FutureUtils() {
    }

    public static <T> T block(CompletableFuture<? extends T> future) {
        try {
            return (T)HttpUtils.waitFor(future);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SW360ClientException) {
                throw (SW360ClientException)e.getCause();
            }
            throw new SW360ClientException("Asynchronous call failed.", e);
        }
    }

    public static <T> CompletableFuture<T> wrapFutureForConditionalFallback(CompletableFuture<T> future, Predicate<? super Throwable> condition, Supplier<? extends CompletableFuture<T>> fallback) {
        return ((CompletableFuture)future.handle((result, exception) -> FutureUtils.exceptionMatches(exception, condition) ? Optional.empty() : Optional.of(future))).thenCompose(optFuture -> (CompletableFuture)optFuture.orElseGet(fallback));
    }

    public static <T> CompletableFuture<Optional<T>> optionalFuture(CompletableFuture<? extends T> future) {
        CompletionStage optFuture = future.thenApply(Optional::of);
        return FutureUtils.wrapFutureForConditionalFallback(optFuture, FutureUtils::resourceNotFound, () -> CompletableFuture.completedFuture(Optional.empty()));
    }

    public static boolean isFailedRequestWithStatus(Throwable exception, int statusCode) {
        return exception instanceof FailedRequestException && ((FailedRequestException)exception).getStatusCode() == statusCode;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    private static boolean exceptionMatches(Throwable exception, Predicate<? super Throwable> condition) {
        return exception != null && condition.test(HttpUtils.unwrapCompletionException((Throwable)exception));
    }

    private static boolean resourceNotFound(Throwable exception) {
        return FutureUtils.isFailedRequestWithStatus(exception, 404);
    }
}

