/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadResult;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360AttachmentAwareClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

class SW360AttachmentUtils {
    private SW360AttachmentUtils() {
    }

    public static <T extends SW360HalResource<?, ?>> CompletableFuture<AttachmentUploadResult<T>> uploadAttachments(SW360AttachmentAwareClient<T> client, AttachmentUploadRequest<T> uploadRequest, Function<? super T, Set<SW360SparseAttachment>> getAttachmentsFunc) {
        CompletionStage<AttachmentUploadResult<T>> futResult = CompletableFuture.completedFuture(new AttachmentUploadResult<T>(uploadRequest.getTarget()));
        for (AttachmentUploadRequest.Item item : uploadRequest.getItems()) {
            futResult = futResult.thenCompose(result -> {
                if (SW360AttachmentUtils.attachmentIsPotentialDuplicate(item.getPath(), (Set)getAttachmentsFunc.apply((Object)result.getTarget()))) {
                    return CompletableFuture.completedFuture(result.addFailedUpload(item, new SW360ClientException("Duplicate attachment file name: " + item.getPath().getFileName())));
                }
                return client.uploadAndAttachAttachment(result.getTarget(), item.getPath(), item.getAttachmentType()).handle((updatedEntity, ex) -> updatedEntity != null ? result.addSuccessfulUpload(updatedEntity, item) : result.addFailedUpload(item, (Throwable)ex));
            });
        }
        return futResult;
    }

    public static <T extends SW360HalResource<?, ?>> CompletableFuture<Optional<Path>> downloadAttachment(SW360AttachmentAwareClient<? extends T> client, T entity, SW360SparseAttachment attachment, Path downloadPath) {
        return Optional.ofNullable(entity.getSelfLink()).map(self -> FutureUtils.optionalFuture(client.downloadAttachment(self.getHref(), attachment, downloadPath))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    private static boolean attachmentIsPotentialDuplicate(Path attachment, Set<SW360SparseAttachment> attachments) {
        return attachments.stream().anyMatch(attachment1 -> attachment1.getFilename().equals(attachment.getFileName().toString()));
    }
}

