/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ComponentClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360SparseComponent;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

class SW360ComponentClientAdapterAsyncImpl
implements SW360ComponentClientAdapterAsync {
    private final SW360ComponentClient componentClient;

    public SW360ComponentClientAdapterAsyncImpl(SW360ComponentClient client) {
        this.componentClient = client;
    }

    @Override
    public SW360ComponentClient getComponentClient() {
        return this.componentClient;
    }

    @Override
    public CompletableFuture<Optional<SW360Component>> getOrCreateComponent(SW360Component componentFromRelease) {
        if (componentFromRelease.getId() != null) {
            return this.getComponentById(componentFromRelease.getId());
        }
        return this.getComponentByName(componentFromRelease.getName()).thenCompose(optComponent -> optComponent.isPresent() ? CompletableFuture.completedFuture(optComponent) : this.createComponent(componentFromRelease).thenApply(Optional::of));
    }

    @Override
    public CompletableFuture<SW360Component> createComponent(SW360Component component) {
        if (!SW360ComponentAdapterUtils.isValidComponent(component)) {
            return FutureUtils.failedFuture(new SW360ClientException("Can not write invalid component for " + component.getName()));
        }
        return this.getComponentClient().createComponent(component);
    }

    @Override
    public CompletableFuture<Optional<SW360Component>> getComponentById(String componentId) {
        return FutureUtils.optionalFuture(this.getComponentClient().getComponent(componentId));
    }

    @Override
    public CompletableFuture<Optional<SW360Component>> getComponentByName(String componentName) {
        return this.getComponentClient().searchByName(componentName).thenCompose(components -> components.stream().filter(c -> c.getName().equals(componentName)).map(c -> SW360HalResourceUtility.getLastIndexOfSelfLink(c.getLinks()).orElse("")).map(this::getComponentById).findFirst().orElse(CompletableFuture.completedFuture(Optional.empty())));
    }

    @Override
    public CompletableFuture<List<SW360SparseComponent>> getComponents() {
        return this.getComponentClient().getComponents();
    }
}

