/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadResult;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360AttachmentUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ReleaseClient;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360ComponentEmbedded;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

class SW360ReleaseClientAdapterAsyncImpl
implements SW360ReleaseClientAdapterAsync {
    private final SW360ReleaseClient releaseClient;
    private final SW360ComponentClientAdapterAsync sw360ComponentClientAdapter;

    public SW360ReleaseClientAdapterAsyncImpl(SW360ReleaseClient client, SW360ComponentClientAdapterAsync componentClientAdapter) {
        this.releaseClient = client;
        this.sw360ComponentClientAdapter = componentClientAdapter;
    }

    @Override
    public SW360ReleaseClient getReleaseClient() {
        return this.releaseClient;
    }

    public SW360ComponentClientAdapterAsync getComponentAdapter() {
        return this.sw360ComponentClientAdapter;
    }

    @Override
    public CompletableFuture<SW360Release> createRelease(SW360Release release) {
        if (!SW360ReleaseAdapterUtils.isValidRelease(release)) {
            return FutureUtils.failedFuture(new SW360ClientException("Can not write invalid release for " + release.getName() + "-" + release.getVersion()));
        }
        if (release.getId() != null) {
            throw new SW360ClientException("Can not write release which already has the id " + release.getId());
        }
        return this.assignReleaseToComponent(release).thenCompose(this.getReleaseClient()::createRelease);
    }

    private CompletableFuture<SW360Release> assignReleaseToComponent(SW360Release release) {
        SW360Component componentFromRelease = SW360ComponentAdapterUtils.createFromRelease(release);
        return this.getComponentAdapter().getOrCreateComponent(componentFromRelease).thenApply(componentFromSW360 -> {
            componentFromSW360.ifPresent(cfs -> {
                if (((SW360ComponentEmbedded)cfs.getEmbedded()).getReleases().stream().map(SW360SparseRelease::getVersion).anyMatch(release.getVersion()::equals)) {
                    throw new SW360ClientException("The release already exists in the found component");
                }
                release.setComponentId(cfs.getId());
            });
            return release;
        });
    }

    @Override
    public CompletableFuture<AttachmentUploadResult<SW360Release>> uploadAttachments(AttachmentUploadRequest<SW360Release> uploadRequest) {
        return SW360AttachmentUtils.uploadAttachments(this.getReleaseClient(), uploadRequest, release -> ((SW360ReleaseEmbedded)release.getEmbedded()).getAttachments());
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> getReleaseById(String releaseId) {
        return FutureUtils.optionalFuture(this.getReleaseClient().getRelease(releaseId));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> enrichSparseRelease(SW360SparseRelease sparseRelease) {
        return this.getReleaseById(sparseRelease.getReleaseId());
    }

    @Override
    public CompletableFuture<Optional<SW360SparseRelease>> getSparseReleaseByExternalIds(Map<String, ?> externalIds) {
        return this.getReleaseClient().getReleasesByExternalIds(externalIds).thenApply(releases -> {
            if (releases.isEmpty()) {
                return Optional.empty();
            }
            if (releases.size() == 1) {
                return Optional.of(releases.get(0));
            }
            throw new SW360ClientException("Multiple releases in SW360 matched by externalIDs: " + externalIds);
        });
    }

    @Override
    public CompletableFuture<Optional<SW360SparseRelease>> getSparseReleaseByNameAndVersion(String componentName, String version) {
        return this.getComponentAdapter().getComponentByName(componentName).thenApply(optComponent -> optComponent.map(SW360HalResource::getEmbedded).map(SW360ComponentEmbedded::getReleases).flatMap(releases -> releases.stream().filter(rel -> version.equals(rel.getVersion())).findFirst()));
    }

    @Override
    public CompletableFuture<Optional<SW360Release>> getReleaseByVersion(SW360Component component, String releaseVersion) {
        List<SW360SparseRelease> releases;
        Optional releaseId;
        if (component != null && component.getEmbedded() != null && ((SW360ComponentEmbedded)component.getEmbedded()).getReleases() != null && (releaseId = (releases = ((SW360ComponentEmbedded)component.getEmbedded()).getReleases()).stream().filter(release -> release.getVersion().equals(releaseVersion)).findFirst().flatMap(release -> SW360HalResourceUtility.getLastIndexOfSelfLink(release.getLinks()))).isPresent()) {
            return this.getReleaseById((String)releaseId.get());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<Path>> downloadAttachment(SW360Release release, SW360SparseAttachment attachment, Path downloadPath) {
        return SW360AttachmentUtils.downloadAttachment(this.getReleaseClient(), release, attachment, downloadPath);
    }

    @Override
    public CompletableFuture<SW360Release> updateRelease(SW360Release release) {
        return this.getReleaseClient().patchRelease(release);
    }
}

