/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360Client;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.LinkObjects;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360Attachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SW360AttachmentAwareClient<T extends SW360HalResource<?, ?>>
extends SW360Client {
    static final String TAG_UPLOAD_ATTACHMENT = "post_upload_attachment";
    static final String TAG_DOWNLOAD_ATTACHMENT = "get_download_attachment";
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360AttachmentAwareClient.class);
    private static final String ATTACHMENTS_ENDPOINT = "/attachments";

    protected SW360AttachmentAwareClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    protected abstract Class<T> getHandledClassType();

    public CompletableFuture<T> uploadAndAttachAttachment(T itemToModify, Path fileToAttach, SW360AttachmentType kindToAttach) {
        if (!Files.exists(fileToAttach, new LinkOption[0])) {
            LOGGER.warn("The file=[{}], which should be attached to release, does not exist", (Object)fileToAttach);
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(new IOException("File to upload does not exist: " + fileToAttach));
            return failedFuture;
        }
        SW360Attachment sw360Attachment = new SW360Attachment(fileToAttach, kindToAttach);
        String self = ((LinkObjects)((SW360HalResource)itemToModify).getLinks()).getSelf().getHref();
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resolveAgainstBase(self + ATTACHMENTS_ENDPOINT).toString()).multiPart("attachment", part -> part.json((Object)sw360Attachment)).multiPart("file", part -> part.file(fileToAttach, "application/octet-stream")), this.getHandledClassType(), TAG_UPLOAD_ATTACHMENT);
    }

    public CompletableFuture<Path> downloadAttachment(String itemHref, SW360SparseAttachment attachment, Path downloadPath) {
        String attachmentId = attachment.getAttachmentId();
        String url = itemHref + "/attachments/" + attachmentId;
        try {
            if (!Files.isDirectory(downloadPath, new LinkOption[0])) {
                LOGGER.debug("Creating download path {}.", (Object)downloadPath);
                Files.createDirectory(downloadPath, new FileAttribute[0]);
            }
            Path targetFile = downloadPath.resolve(attachment.getFilename());
            return this.executeRequest(builder -> builder.uri(this.resolveAgainstBase(url).toString()).header("Accept", "application/octet-stream"), response -> {
                Files.copy(response.bodyStream(), targetFile, StandardCopyOption.REPLACE_EXISTING);
                return targetFile;
            }, TAG_DOWNLOAD_ATTACHMENT);
        }
        catch (IOException e) {
            LOGGER.warn("Request to write downloaded attachment {} to {} failed with {}", new Object[]{attachment.getFilename(), downloadPath, e.getMessage()});
            LOGGER.debug("Error: ", (Throwable)e);
            CompletableFuture<Path> failedFuture = new CompletableFuture<Path>();
            failedFuture.completeExceptionally(e);
            return failedFuture;
        }
    }
}

