/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360Client;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360ComponentList;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360SparseComponent;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ResourceUtils;

public class SW360ComponentClient
extends SW360Client {
    static final String TAG_GET_COMPONENTS = "get_components";
    static final String TAG_GET_COMPONENT = "get_component";
    static final String TAG_GET_COMPONENTS_BY_NAME = "get_components_by_name";
    static final String TAG_CREATE_COMPONENT = "post_create_component";
    private static final String COMPONENTS_ENDPOINT = "components";

    public SW360ComponentClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<SW360Component> getComponent(String componentId) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(COMPONENTS_ENDPOINT, componentId)), SW360Component.class, TAG_GET_COMPONENT);
    }

    public CompletableFuture<List<SW360SparseComponent>> getComponents() {
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)this.resourceUrl(COMPONENTS_ENDPOINT)), SW360ComponentList.class, TAG_GET_COMPONENTS, SW360ComponentList::new).thenApply(SW360ResourceUtils::getSw360SparseComponents);
    }

    public CompletableFuture<List<SW360SparseComponent>> searchByName(String name) {
        String url = HttpUtils.addQueryParameter((String)this.resourceUrl(COMPONENTS_ENDPOINT), (String)"name", (Object)name);
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)url), SW360ComponentList.class, TAG_GET_COMPONENTS_BY_NAME, SW360ComponentList::new).thenApply(SW360ResourceUtils::getSw360SparseComponents);
    }

    public CompletableFuture<SW360Component> createComponent(SW360Component sw360Component) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(COMPONENTS_ENDPOINT)).body(body -> body.json((Object)sw360Component)), SW360Component.class, TAG_CREATE_COMPONENT);
    }
}

