/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;

public final class AttachmentUploadRequest<T extends SW360HalResource<?, ?>> {
    private final T target;
    private final List<Item> items;

    private AttachmentUploadRequest(T target, List<Item> items) {
        this.target = target;
        this.items = Collections.unmodifiableList(new ArrayList<Item>(items));
    }

    public static <T extends SW360HalResource<?, ?>> Builder<T> builder(T target) {
        return new Builder(target, null);
    }

    public T getTarget() {
        return this.target;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentUploadRequest request = (AttachmentUploadRequest)o;
        return Objects.equals(this.getTarget(), request.getTarget()) && this.items.equals(request.items);
    }

    public int hashCode() {
        return Objects.hash(this.getTarget(), this.items);
    }

    public String toString() {
        return "AttachmentUploadRequest{target=" + this.target + ", items=" + this.items + '}';
    }

    /* synthetic */ AttachmentUploadRequest(SW360HalResource x0, List x1, 1 x2) {
        this(x0, x1);
    }

    public static class Builder<T extends SW360HalResource<?, ?>> {
        private final T target;
        private final List<Item> items;

        private Builder(T target) {
            this.target = target;
            this.items = new LinkedList<Item>();
        }

        public Builder<T> addAttachment(Path attachmentPath, SW360AttachmentType attachmentType) {
            this.items.add(new Item(attachmentPath, attachmentType));
            return this;
        }

        public AttachmentUploadRequest<T> build() {
            return new AttachmentUploadRequest((SW360HalResource)this.target, this.items, null);
        }

        /* synthetic */ Builder(SW360HalResource x0, 1 x1) {
            this(x0);
        }
    }

    public static final class Item {
        private final Path path;
        private final SW360AttachmentType attachmentType;

        public Item(Path path, SW360AttachmentType attachmentType) {
            this.path = path;
            this.attachmentType = attachmentType;
        }

        public Path getPath() {
            return this.path;
        }

        public SW360AttachmentType getAttachmentType() {
            return this.attachmentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.getPath(), item.getPath()) && this.getAttachmentType() == item.getAttachmentType();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getPath(), this.getAttachmentType()});
        }

        public String toString() {
            return "Item{path=" + this.path + ", attachmentType=" + (Object)((Object)this.attachmentType) + '}';
        }
    }
}

