/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.auth;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.eclipse.sw360.antenna.http.RequestBuilder;

public final class AccessToken {
    private final String token;

    public AccessToken(String token) {
        this.token = (String)Validate.notEmpty((CharSequence)token, (String)"Undefined access token", (Object[])new Object[0]);
    }

    public String getToken() {
        return this.token;
    }

    public RequestBuilder addToken(RequestBuilder builder) {
        return builder.header("Authorization", "Bearer " + this.getToken());
    }

    public Consumer<RequestBuilder> tokenProducer(Consumer<? super RequestBuilder> producer) {
        return builder -> producer.accept(this.addToken((RequestBuilder)builder));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return this.getToken().equals(that.getToken());
    }

    public int hashCode() {
        return Objects.hash(this.getToken());
    }
}

