/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;

public final class AttachmentUploadResult<T extends SW360HalResource<?, ?>> {
    private final T target;
    private final Set<AttachmentUploadRequest.Item> successfulUploads;
    private final Map<AttachmentUploadRequest.Item, Throwable> failedUploads;

    public AttachmentUploadResult(T target) {
        this(target, Collections.emptySet(), Collections.emptyMap());
    }

    private AttachmentUploadResult(T target, Set<AttachmentUploadRequest.Item> successfulUploads, Map<AttachmentUploadRequest.Item, Throwable> failedUploads) {
        this.target = target;
        this.successfulUploads = successfulUploads;
        this.failedUploads = failedUploads;
    }

    public static <T extends SW360HalResource<?, ?>> AttachmentUploadResult<T> newResult(T target, Set<AttachmentUploadRequest.Item> successfulUploads, Map<AttachmentUploadRequest.Item, Throwable> failedUploads) {
        return new AttachmentUploadResult<T>(target, Collections.unmodifiableSet(new HashSet<AttachmentUploadRequest.Item>(successfulUploads)), Collections.unmodifiableMap(new HashMap<AttachmentUploadRequest.Item, Throwable>(failedUploads)));
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isSuccess() {
        return this.failedUploads.isEmpty();
    }

    public Set<AttachmentUploadRequest.Item> successfulUploads() {
        return this.successfulUploads;
    }

    public Map<AttachmentUploadRequest.Item, Throwable> failedUploads() {
        return this.failedUploads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentUploadResult result = (AttachmentUploadResult)o;
        return Objects.equals(this.getTarget(), result.getTarget()) && this.successfulUploads.equals(result.successfulUploads) && this.failedUploads.equals(result.failedUploads);
    }

    public int hashCode() {
        return Objects.hash(this.getTarget(), this.successfulUploads, this.failedUploads);
    }

    public String toString() {
        return "AttachmentUploadResult{target=" + this.target + ", successfulUploads=" + this.successfulUploads + ", failedUploads=" + this.failedUploads + '}';
    }

    AttachmentUploadResult<T> addSuccessfulUpload(T updatedTarget, AttachmentUploadRequest.Item item) {
        HashSet<AttachmentUploadRequest.Item> updatedSet = new HashSet<AttachmentUploadRequest.Item>(this.successfulUploads);
        updatedSet.add(item);
        return new AttachmentUploadResult<T>(updatedTarget, Collections.unmodifiableSet(updatedSet), this.failedUploads);
    }

    AttachmentUploadResult<T> addFailedUpload(AttachmentUploadRequest.Item item, Throwable exception) {
        HashMap<AttachmentUploadRequest.Item, Throwable> updatedMap = new HashMap<AttachmentUploadRequest.Item, Throwable>(this.failedUploads);
        updatedMap.put(item, exception);
        return new AttachmentUploadResult<T>(this.getTarget(), this.successfulUploads, Collections.unmodifiableMap(updatedMap));
    }
}

