/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.adapter;

import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentClientAdapterAsyncImpl;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapterAsyncImpl;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapterAsyncImpl;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapterAsync;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapterAsyncImpl;
import org.eclipse.sw360.antenna.sw360.client.adapter.SyncClientAdapterHandler;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.auth.SW360AuthenticationClient;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ComponentClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360LicenseClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ProjectClient;
import org.eclipse.sw360.antenna.sw360.client.rest.SW360ReleaseClient;

public class SW360ConnectionFactory {
    public SW360Connection newConnection(SW360ClientConfig config) {
        SW360AuthenticationClient authClient = new SW360AuthenticationClient(config);
        AccessTokenProvider tokenProvider = new AccessTokenProvider(authClient);
        SW360ComponentClient componentClient = new SW360ComponentClient(config, tokenProvider);
        final SW360ComponentClientAdapterAsyncImpl componentAdapterAsync = new SW360ComponentClientAdapterAsyncImpl(componentClient);
        final SW360ComponentClientAdapter componentAdapterSync = SyncClientAdapterHandler.newHandler(SW360ComponentClientAdapter.class, SW360ComponentClientAdapterAsync.class, componentAdapterAsync);
        SW360ReleaseClient releaseClient = new SW360ReleaseClient(config, tokenProvider);
        final SW360ReleaseClientAdapterAsyncImpl releaseAdapterAsync = new SW360ReleaseClientAdapterAsyncImpl(releaseClient, componentAdapterAsync);
        final SW360ReleaseClientAdapter releaseAdapterSync = SyncClientAdapterHandler.newHandler(SW360ReleaseClientAdapter.class, SW360ReleaseClientAdapterAsync.class, releaseAdapterAsync);
        SW360LicenseClient licenseClient = new SW360LicenseClient(config, tokenProvider);
        final SW360LicenseClientAdapterAsyncImpl licenseAdapterAsync = new SW360LicenseClientAdapterAsyncImpl(licenseClient);
        final SW360LicenseClientAdapter licenseAdapterSync = SyncClientAdapterHandler.newHandler(SW360LicenseClientAdapter.class, SW360LicenseClientAdapterAsync.class, licenseAdapterAsync);
        SW360ProjectClient projectClient = new SW360ProjectClient(config, tokenProvider);
        final SW360ProjectClientAdapterAsyncImpl projectAdapterAsync = new SW360ProjectClientAdapterAsyncImpl(projectClient);
        final SW360ProjectClientAdapter projectAdapterSync = SyncClientAdapterHandler.newHandler(SW360ProjectClientAdapter.class, SW360ProjectClientAdapterAsync.class, projectAdapterAsync);
        return new SW360Connection(){

            @Override
            public SW360ComponentClientAdapter getComponentAdapter() {
                return componentAdapterSync;
            }

            @Override
            public SW360ComponentClientAdapterAsync getComponentAdapterAsync() {
                return componentAdapterAsync;
            }

            @Override
            public SW360ReleaseClientAdapter getReleaseAdapter() {
                return releaseAdapterSync;
            }

            @Override
            public SW360ReleaseClientAdapterAsync getReleaseAdapterAsync() {
                return releaseAdapterAsync;
            }

            @Override
            public SW360LicenseClientAdapter getLicenseAdapter() {
                return licenseAdapterSync;
            }

            @Override
            public SW360LicenseClientAdapterAsync getLicenseAdapterAsync() {
                return licenseAdapterAsync;
            }

            @Override
            public SW360ProjectClientAdapter getProjectAdapter() {
                return projectAdapterSync;
            }

            @Override
            public SW360ProjectClientAdapterAsync getProjectAdapterAsync() {
                return projectAdapterAsync;
            }
        };
    }
}

