/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.sw360.antenna.http.HttpClient;

public final class SW360ClientConfig {
    private final URI baseURI;
    private final String authURL;
    private final String user;
    private final String password;
    private final String clientId;
    private final String clientPassword;
    private final String token;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    private SW360ClientConfig(URI baseURI, String authURL, String user, String password, String clientId, String clientPassword, String token, HttpClient httpClient, ObjectMapper objectMapper) {
        this.baseURI = baseURI;
        this.authURL = authURL;
        this.user = user;
        this.password = password;
        this.clientId = clientId;
        this.clientPassword = clientPassword;
        this.token = token;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public static SW360ClientConfig createConfig(String restURL, String authURL, String user, String password, String clientId, String clientPassword, String token, HttpClient httpClient, ObjectMapper mapper) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            return new SW360ClientConfig(URI.create(SW360ClientConfig.stripTrailingSeparator((String)Validate.notEmpty((CharSequence)restURL, (String)"Undefined REST URL", (Object[])new Object[0]))), SW360ClientConfig.stripTrailingSeparator((String)Validate.notEmpty((CharSequence)authURL, (String)"Undefined authentication URL", (Object[])new Object[0])), user, password, (String)Validate.notEmpty((CharSequence)clientId, (String)"Undefined client ID", (Object[])new Object[0]), (String)Validate.notEmpty((CharSequence)clientPassword, (String)"Undefined client password", (Object[])new Object[0]), (String)Validate.notEmpty((CharSequence)token, (String)"Undefined token", (Object[])new Object[0]), (HttpClient)Validate.notNull((Object)httpClient), (ObjectMapper)Validate.notNull((Object)mapper));
        }
        return new SW360ClientConfig(URI.create(SW360ClientConfig.stripTrailingSeparator((String)Validate.notEmpty((CharSequence)restURL, (String)"Undefined REST URL", (Object[])new Object[0]))), SW360ClientConfig.stripTrailingSeparator((String)Validate.notEmpty((CharSequence)authURL, (String)"Undefined authentication URL", (Object[])new Object[0])), (String)Validate.notEmpty((CharSequence)user, (String)"Undefined user", (Object[])new Object[0]), (String)Validate.notEmpty((CharSequence)password, (String)"Undefined password", (Object[])new Object[0]), (String)Validate.notEmpty((CharSequence)clientId, (String)"Undefined client ID", (Object[])new Object[0]), (String)Validate.notEmpty((CharSequence)clientPassword, (String)"Undefined client password", (Object[])new Object[0]), token, (HttpClient)Validate.notNull((Object)httpClient), (ObjectMapper)Validate.notNull((Object)mapper));
    }

    public String getRestURL() {
        return this.baseURI.toString();
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public String getAuthURL() {
        return this.authURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientPassword() {
        return this.clientPassword;
    }

    public String getToken() {
        if (StringUtils.isBlank((CharSequence)this.token) || StringUtils.equalsIgnoreCase((CharSequence)this.token, (CharSequence)"none")) {
            return "";
        }
        return this.token;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SW360ClientConfig that = (SW360ClientConfig)o;
        return this.getRestURL().equals(that.getRestURL()) && this.getAuthURL().equals(that.getAuthURL()) && this.getUser().equals(that.getUser()) && this.getPassword().equals(that.getPassword()) && this.getClientId().equals(that.getClientId()) && this.getClientPassword().equals(that.getClientPassword()) && this.getToken().equals(that.getToken()) && this.getHttpClient().equals(that.getHttpClient()) && this.getObjectMapper().equals(that.getObjectMapper());
    }

    public int hashCode() {
        return Objects.hash(this.getRestURL(), this.getAuthURL(), this.getUser(), this.getPassword(), this.getClientId(), this.getClientPassword(), this.getToken(), this.getHttpClient(), this.getObjectMapper());
    }

    private static String stripTrailingSeparator(String url) {
        return StringUtils.stripEnd((String)url, (String)"/");
    }
}

