/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.ResponseProcessor;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.auth.AccessTokenProvider;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;
import org.eclipse.sw360.antenna.sw360.client.rest.MultiStatusResponse;
import org.eclipse.sw360.antenna.sw360.client.utils.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SW360Client {
    private static final String URI_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(SW360Client.class);
    private final SW360ClientConfig clientConfig;
    private final AccessTokenProvider tokenProvider;

    protected SW360Client(SW360ClientConfig config, AccessTokenProvider tokenProvider) {
        this.clientConfig = config;
        this.tokenProvider = tokenProvider;
    }

    public SW360ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public AccessTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    protected <T> CompletableFuture<T> executeRequest(Consumer<? super RequestBuilder> producer, ResponseProcessor<T> processor, String tag) {
        return this.manageTokenAndExecute(producer, processor, tag, true);
    }

    protected <T> CompletableFuture<T> executeJsonRequest(Consumer<? super RequestBuilder> producer, Class<T> resultClass, String tag) {
        return this.executeRequest(producer, HttpUtils.jsonResult((ObjectMapper)this.getClientConfig().getObjectMapper(), resultClass), tag);
    }

    protected CompletableFuture<MultiStatusResponse> executeDeleteRequest(String endpoint, Collection<String> idsToDelete, String tag) {
        String strIdsToDelete = String.join((CharSequence)",", idsToDelete);
        String url = this.resourceUrl(endpoint, strIdsToDelete);
        return this.executeRequest(builder -> builder.uri(url).method(RequestBuilder.Method.DELETE), this.createMultiStatusProcessor(tag), tag);
    }

    protected <T> CompletableFuture<T> executeJsonRequestWithDefault(Consumer<? super RequestBuilder> producer, Class<T> resultClass, String tag, Supplier<? extends T> defaultResult) {
        ResponseProcessor processor = response -> response.statusCode() == 204 ? defaultResult.get() : HttpUtils.jsonResult((ObjectMapper)this.getClientConfig().getObjectMapper(), (Class)resultClass).process(response);
        return this.executeRequest(producer, processor, tag);
    }

    protected String resourceUrl(String ... paths) {
        return this.getClientConfig().getRestURL() + URI_SEPARATOR + String.join((CharSequence)URI_SEPARATOR, paths);
    }

    protected URI resolveAgainstBase(String uri) {
        URI base = this.getClientConfig().getBaseURI();
        URI source = URI.create(uri);
        String path = SW360Client.resolvePath(base, source);
        try {
            return new URI(base.getScheme(), base.getAuthority(), path, source.getQuery(), source.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI to resolve: " + uri);
        }
    }

    private <T> CompletableFuture<T> manageTokenAndExecute(Consumer<? super RequestBuilder> producer, ResponseProcessor<T> processor, String tag, boolean canRetry) {
        LOG.debug("Executing request '{}'{}.", (Object)tag, (Object)(canRetry ? "" : " (retry)"));
        CompletableFuture futRequest = this.getTokenProvider().doWithToken(accessToken -> this.getClientConfig().getHttpClient().execute(accessToken.tokenProducer(producer), HttpUtils.checkResponse((ResponseProcessor)processor, (String)tag)));
        return canRetry ? FutureUtils.wrapFutureForConditionalFallback(futRequest, this::checkIfRetry, () -> this.manageTokenAndExecute(producer, processor, tag, false)) : futRequest;
    }

    private boolean checkIfRetry(Throwable exception) {
        return FutureUtils.isFailedRequestWithStatus(exception, 401);
    }

    private ResponseProcessor<MultiStatusResponse> createMultiStatusProcessor(String tag) {
        ResponseProcessor processor = response -> MultiStatusResponse.fromJson(this.getClientConfig().getObjectMapper(), response.bodyStream());
        return HttpUtils.checkResponse((ResponseProcessor)processor, (Predicate)HttpUtils.hasStatus((int)207), (String)tag);
    }

    private static String resolvePath(URI base, URI source) {
        String[] baseComponents = base.getPath().split(URI_SEPARATOR);
        String[] sourceComponents = source.getPath().split(URI_SEPARATOR);
        int minLength = Math.min(baseComponents.length, sourceComponents.length);
        for (int idx = 0; idx < minLength && baseComponents[idx].equals(sourceComponents[idx]); ++idx) {
        }
        StringBuilder buf = new StringBuilder();
        buf.append(base.getPath());
        for (int i = idx; i < sourceComponents.length; ++i) {
            buf.append(URI_SEPARATOR).append(sourceComponents[i]);
        }
        return buf.toString();
    }
}

