/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360SimpleHalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentCheckStatus;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

public final class SW360Attachment
extends SW360SimpleHalResource {
    private String filename;
    private SW360AttachmentType attachmentType;
    private SW360AttachmentCheckStatus checkStatus;

    public SW360Attachment() {
    }

    public SW360Attachment(Path path, SW360AttachmentType attachmentType) {
        this(Optional.ofNullable(path).map(Path::getFileName).orElseThrow(() -> new SW360ClientException("Tried to add null path.")).toString(), attachmentType);
    }

    public SW360Attachment(String filename, SW360AttachmentType attachmentType) {
        this.filename = Optional.ofNullable(filename).orElseThrow(() -> new SW360ClientException("Filename is not allowed to be null."));
        this.attachmentType = attachmentType;
        this.checkStatus = SW360AttachmentCheckStatus.NOTCHECKED;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFilename() {
        return this.filename;
    }

    public SW360Attachment setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SW360AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public SW360Attachment setAttachmentType(SW360AttachmentType attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SW360AttachmentCheckStatus getCheckStatus() {
        return this.checkStatus;
    }

    public SW360Attachment setCheckStatus(SW360AttachmentCheckStatus checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SW360Attachment) || !super.equals(object)) {
            return false;
        }
        SW360Attachment that = (SW360Attachment)object;
        return Objects.equals(this.filename, that.filename) && Objects.equals((Object)this.attachmentType, (Object)that.attachmentType) && Objects.equals((Object)this.checkStatus, (Object)that.checkStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.filename, this.attachmentType, this.checkStatus});
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof SW360Attachment;
    }
}

