/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.rest.resource.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360ComponentType;

public final class ComponentSearchParams {
    public static final ComponentSearchParams ALL_COMPONENTS = ComponentSearchParams.builder().build();
    private static final String SORT_ASC = ",ASC";
    private static final String SORT_DESC = ",DESC";
    private final String name;
    private final String componentType;
    private final String pageIndex;
    private final String pageSize;
    private final List<String> orderClauses;
    private final List<String> fields;

    private ComponentSearchParams(Builder builder) {
        this.name = builder.name;
        this.componentType = builder.componentType != null ? builder.componentType.name() : null;
        this.pageIndex = builder.pageIndex >= 0 ? String.valueOf(builder.pageIndex) : null;
        this.pageSize = builder.pageSize > 0 ? String.valueOf(builder.pageSize) : null;
        this.orderClauses = Collections.unmodifiableList(new ArrayList(builder.orderClauses));
        this.fields = Collections.unmodifiableList(new ArrayList(builder.fields));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getPageIndex() {
        return this.pageIndex;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public List<String> getOrderClauses() {
        return this.orderClauses;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentSearchParams params = (ComponentSearchParams)o;
        return Objects.equals(this.getName(), params.getName()) && Objects.equals(this.getComponentType(), params.getComponentType()) && Objects.equals(this.getPageIndex(), params.getPageIndex()) && Objects.equals(this.getPageSize(), params.getPageSize()) && this.getOrderClauses().equals(params.getOrderClauses()) && this.getFields().equals(params.getFields());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getComponentType(), this.getPageIndex(), this.getPageSize(), this.getOrderClauses(), this.getFields());
    }

    public static class Builder {
        private String name;
        private SW360ComponentType componentType;
        private int pageIndex = -1;
        private int pageSize = -1;
        private final List<String> orderClauses = new ArrayList<String>();
        private final List<String> fields = new ArrayList<String>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withComponentType(SW360ComponentType componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder withPage(int pageIndex) {
            this.pageIndex = pageIndex;
            return this;
        }

        public Builder withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder orderAscending(String field) {
            this.orderClauses.add(field + ComponentSearchParams.SORT_ASC);
            return this;
        }

        public Builder orderDescending(String field) {
            this.orderClauses.add(field + ComponentSearchParams.SORT_DESC);
            return this;
        }

        public Builder retrieveFields(String ... fields) {
            this.fields.addAll(Arrays.asList(fields));
            return this;
        }

        public ComponentSearchParams build() {
            return new ComponentSearchParams(this);
        }
    }
}

