/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.client.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.sw360.antenna.http.utils.FailedRequestException;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;

public class FutureUtils {
    private FutureUtils() {
    }

    public static <T> T block(CompletableFuture<? extends T> future) {
        try {
            return (T)HttpUtils.waitFor(future);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SW360ClientException) {
                throw (SW360ClientException)e.getCause();
            }
            throw new SW360ClientException("Asynchronous call failed.", e);
        }
    }

    public static <T> CompletableFuture<T> wrapFutureForConditionalFallback(CompletableFuture<T> future, Predicate<? super Throwable> condition, Supplier<? extends CompletableFuture<T>> fallback) {
        return ((CompletableFuture)future.handle((result, exception) -> FutureUtils.exceptionMatches(exception, condition) ? Optional.empty() : Optional.of(future))).thenCompose(optFuture -> (CompletableFuture)optFuture.orElseGet(fallback));
    }

    public static <T> CompletableFuture<Optional<T>> optionalFuture(CompletableFuture<? extends T> future) {
        CompletionStage optFuture = future.thenApply(Optional::of);
        return FutureUtils.wrapFutureForConditionalFallback(optFuture, FutureUtils::resourceNotFound, () -> CompletableFuture.completedFuture(Optional.empty()));
    }

    public static <T> CompletableFuture<T> orFallback(CompletableFuture<Optional<T>> future, Supplier<? extends CompletableFuture<T>> fallback) {
        return future.thenCompose(optResult -> optResult.map(CompletableFuture::completedFuture).orElseGet(fallback));
    }

    public static <T> CompletableFuture<Optional<T>> orRetry(CompletableFuture<Optional<T>> future, Supplier<? extends CompletableFuture<Optional<T>>> retry) {
        return future.thenCompose(optResult -> optResult.isPresent() ? CompletableFuture.completedFuture(optResult) : (CompletionStage)retry.get());
    }

    public static boolean isFailedRequestWithStatus(Throwable exception, int statusCode) {
        return exception instanceof FailedRequestException && ((FailedRequestException)exception).getStatusCode() == statusCode;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static <T> CompletableFuture<Collection<T>> sequence(Collection<CompletableFuture<T>> futures, Function<Throwable, Boolean> exceptionHandler) {
        ConcurrentHashMap results = new ConcurrentHashMap();
        AtomicReference exception = new AtomicReference();
        CompletableFuture[] futuresArray = (CompletableFuture[])futures.stream().map(f -> f.handle((result, ex) -> {
            if (ex != null) {
                if (((Boolean)exceptionHandler.apply((Throwable)ex)).booleanValue()) {
                    exception.compareAndSet(null, ex);
                }
            } else {
                results.put(result, Boolean.TRUE);
            }
            return result;
        })).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futuresArray).thenCompose(v -> {
            Throwable failure = (Throwable)exception.get();
            return failure != null ? FutureUtils.failedFuture(failure) : CompletableFuture.completedFuture(results.keySet());
        });
    }

    public static <T> CompletableFuture<T> wrapInFuture(Callable<? extends T> action, String errMsg) {
        try {
            return CompletableFuture.completedFuture(action.call());
        }
        catch (Exception e) {
            return FutureUtils.failedFuture(new SW360ClientException(errMsg, e));
        }
    }

    private static boolean exceptionMatches(Throwable exception, Predicate<? super Throwable> condition) {
        return exception != null && condition.test(HttpUtils.unwrapCompletionException((Throwable)exception));
    }

    private static boolean resourceNotFound(Throwable exception) {
        return FutureUtils.isFailedRequestWithStatus(exception, 404);
    }
}

