/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360;

import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ComponentClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.api.SW360Connection;
import org.eclipse.sw360.antenna.sw360.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.rest.resource.components.SW360Component;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToComponentUtils;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToReleaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360MetaDataReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360MetaDataReceiver.class);
    private SW360ComponentClientAdapter componentClientAdapter;
    private SW360ReleaseClientAdapter releaseClientAdapter;
    private SW360LicenseClientAdapter licenseClientAdapter;

    public SW360MetaDataReceiver(SW360Connection sw360ConnectionConfiguration) {
        this.componentClientAdapter = sw360ConnectionConfiguration.getComponentAdapter();
        this.releaseClientAdapter = sw360ConnectionConfiguration.getReleaseAdapter();
        this.licenseClientAdapter = sw360ConnectionConfiguration.getLicenseAdapter();
    }

    public Optional<SW360Release> findReleaseForArtifact(Artifact artifact) {
        Optional<SW360Component> component = this.getComponentByArtifact(artifact);
        if (component.isPresent()) {
            String releaseVersionOfArtifact = ArtifactToReleaseUtils.createSW360ReleaseVersion(artifact);
            return this.releaseClientAdapter.getReleaseByVersion(component.get(), releaseVersionOfArtifact);
        }
        return Optional.empty();
    }

    public Optional<SW360License> getLicenseDetails(SW360SparseLicense sparseLicense) {
        return this.licenseClientAdapter.getLicenseDetails(sparseLicense);
    }

    public Optional<Path> downloadAttachment(SW360Release release, SW360SparseAttachment attachment, Path downloadPath) {
        return this.releaseClientAdapter.downloadAttachment(release, attachment, downloadPath);
    }

    private Optional<SW360Component> getComponentByArtifact(Artifact artifact) {
        try {
            String componentName = ArtifactToComponentUtils.createComponentName(artifact);
            return this.componentClientAdapter.getComponentByName(componentName);
        }
        catch (ExecutionException e) {
            LOGGER.debug("No component found for {}. Reason: {}", (Object)artifact.prettyPrint(), (Object)e.getMessage());
            LOGGER.debug("Error: ", (Throwable)e);
            return Optional.empty();
        }
    }
}

