/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.sw360.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.antenna.sw360.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.api.SW360Connection;
import org.eclipse.sw360.antenna.sw360.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360MetaDataUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360MetaDataUpdater.class);
    private SW360ProjectClientAdapter projectClientAdapter;
    private SW360LicenseClientAdapter licenseClientAdapter;
    private SW360ReleaseClientAdapter releaseClientAdapter;
    private final boolean updateReleases;
    private final boolean uploadSources;

    public SW360MetaDataUpdater(SW360Connection connection, boolean updateReleases, boolean uploadSources) {
        this.projectClientAdapter = connection.getProjectAdapter();
        this.licenseClientAdapter = connection.getLicenseAdapter();
        this.releaseClientAdapter = connection.getReleaseAdapter();
        this.updateReleases = updateReleases;
        this.uploadSources = uploadSources;
    }

    public Set<SW360License> getLicenses(Collection<License> licenses) {
        return licenses.stream().filter(this::isLicenseInSW360).map(license -> this.licenseClientAdapter.getSW360LicenseByAntennaLicense(license.getId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private boolean isLicenseInSW360(License license) {
        if (this.licenseClientAdapter.isLicenseOfArtifactAvailable(license.getId())) {
            LOGGER.debug("License [{}] found in SW360.", (Object)license.getId());
            return true;
        }
        LOGGER.debug("License [{}] unknown in SW360.", (Object)license.getId());
        return false;
    }

    public SW360Release getOrCreateRelease(SW360Release sw360ReleaseFromArtifact) {
        return this.releaseClientAdapter.getOrCreateRelease(sw360ReleaseFromArtifact, this.updateReleases);
    }

    public void createProject(String projectName, String projectVersion, Collection<SW360Release> releases) {
        String id;
        Optional projectId = this.projectClientAdapter.getProjectIdByNameAndVersion(projectName, projectVersion);
        if (projectId.isPresent()) {
            LOGGER.debug("Could not update project {}, because the endpoint is not available.", projectId.get());
            id = (String)projectId.get();
        } else {
            id = this.projectClientAdapter.addProject(projectName, projectVersion);
        }
        this.projectClientAdapter.addSW360ReleasesToSW360Project(id, releases);
    }

    public boolean isUploadSources() {
        return this.uploadSources;
    }

    public SW360Release uploadAttachments(SW360Release sw360Release, Map<Path, SW360AttachmentType> attachments) {
        return this.releaseClientAdapter.uploadAttachments(sw360Release, attachments);
    }
}

