/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactCPE;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactChangeStatus;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactClearingState;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFilename;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactReleaseTagURL;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSoftwareHeritageID;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceUrl;
import org.eclipse.sw360.antenna.model.artifact.facts.CopyrightStatement;
import org.eclipse.sw360.antenna.model.artifact.facts.DeclaredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ObservedLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.OverriddenLicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToComponentUtils;
import org.eclipse.sw360.antenna.util.LicenseSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactToReleaseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactToReleaseUtils.class);

    private ArtifactToReleaseUtils() {
    }

    public static Artifact convertToArtifactWithoutSourceFile(SW360Release release, Artifact artifact) {
        artifact.setProprietary(release.isProprietary());
        Optional.ofNullable(release.getCoordinates()).map(Map::values).map(HashSet::new).map(ArtifactCoordinates::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        ArtifactToReleaseUtils.addLicenseFact(Optional.ofNullable(release.getDeclaredLicense()), artifact, DeclaredLicenseInformation::new, artifact.askFor(DeclaredLicenseInformation.class).isPresent());
        ArtifactToReleaseUtils.addLicenseFact(Optional.ofNullable(release.getObservedLicense()), artifact, ObservedLicenseInformation::new, artifact.askFor(ObservedLicenseInformation.class).isPresent());
        ArtifactToReleaseUtils.addLicenseFact(Optional.ofNullable(release.getOverriddenLicense()), artifact, OverriddenLicenseInformation::new, artifact.askFor(OverriddenLicenseInformation.class).isPresent());
        String cpeId = release.getCpeId();
        if (cpeId != null && cpeId.startsWith("cpe:")) {
            artifact.addFact((ArtifactFact)new ArtifactCPE(cpeId));
        }
        Optional.ofNullable(release.getDownloadurl()).map(ArtifactSourceUrl::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        Optional.ofNullable(release.getReleaseTagUrl()).map(ArtifactReleaseTagURL::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        try {
            Optional.ofNullable(release.getSoftwareHeritageId()).map(ArtifactSoftwareHeritageID.Builder::new).map(ArtifactSoftwareHeritageID.Builder::build).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug(e.getMessage());
        }
        Optional.ofNullable(release.getChangeStatus()).map(ArtifactChangeStatus.ChangeStatus::valueOf).map(ArtifactChangeStatus::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        Optional.ofNullable(release.getClearingState()).map(ArtifactClearingState.ClearingState::valueOf).map(ArtifactClearingState::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        Optional.ofNullable(release.getCopyrights()).map(CopyrightStatement::new).ifPresent(arg_0 -> ((Artifact)artifact).addFact(arg_0));
        if (release.getHashes() != null) {
            Set hashes = release.getHashes();
            hashes.forEach(hash -> artifact.addFact((ArtifactFact)new ArtifactFilename("", hash)));
        }
        return artifact;
    }

    static void addLicenseFact(Optional<String> licenseRawData, Artifact artifact, Function<LicenseInformation, ArtifactLicenseInformation> licenseCreator, boolean isAlreadyPresent) {
        licenseRawData.map(LicenseSupport::parseSpdxExpression).map(licenseCreator).ifPresent(expression -> ArtifactToReleaseUtils.addFactAndLogWarning(artifact, isAlreadyPresent, expression));
    }

    private static void addFactAndLogWarning(Artifact artifact, boolean isAlreadyPresent, ArtifactLicenseInformation expression) {
        if (isAlreadyPresent) {
            LOGGER.debug("License information of type {} found in SW360. Overwriting existing information in artifact.", (Object)expression.getClass().getSimpleName());
        }
        artifact.addFact((ArtifactFact)expression);
    }

    public static SW360Release convertToReleaseWithoutAttachments(Artifact artifact) {
        SW360Release release = new SW360Release();
        String componentName = ArtifactToComponentUtils.createComponentName(artifact);
        ArtifactToReleaseUtils.setVersion(release, artifact);
        ArtifactToReleaseUtils.setCPEId(release, artifact);
        release.setName(componentName);
        ArtifactToReleaseUtils.setCoordinates(release, artifact);
        ArtifactToReleaseUtils.setOverriddenLicense(release, artifact);
        ArtifactToReleaseUtils.setDeclaredLicense(release, artifact);
        ArtifactToReleaseUtils.setObservedLicense(release, artifact);
        ArtifactToReleaseUtils.setSourceUrl(release, artifact);
        ArtifactToReleaseUtils.setReleaseTagUrl(release, artifact);
        ArtifactToReleaseUtils.setSwhId(release, artifact);
        ArtifactToReleaseUtils.setHashes(release, artifact);
        ArtifactToReleaseUtils.setClearingStatus(release, artifact);
        ArtifactToReleaseUtils.setChangeStatus(release, artifact);
        ArtifactToReleaseUtils.setCopyrights(release, artifact);
        release.setProprietary(artifact.isProprietary());
        return release;
    }

    public static String createSW360ReleaseVersion(Artifact artifact) {
        return ArtifactToComponentUtils.createComponentVersion(artifact);
    }

    public static void setVersion(SW360Release release, Artifact artifact) {
        String version = ArtifactToReleaseUtils.createSW360ReleaseVersion(artifact);
        if (!version.isEmpty()) {
            release.setVersion(version);
        }
    }

    private static void setCPEId(SW360Release release, Artifact artifact) {
        artifact.askForGet(ArtifactCPE.class).ifPresent(arg_0 -> ((SW360Release)release).setCpeId(arg_0));
    }

    private static void setCoordinates(SW360Release release, Artifact artifact) {
        release.setCoordinates(ArtifactToReleaseUtils.getMapOfCoordinates(artifact));
    }

    private static Map<String, String> getMapOfCoordinates(Artifact artifact) {
        HashMap<String, String> coordinates = new HashMap<String, String>();
        artifact.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getCoordinates).ifPresent(packageURLS -> packageURLS.forEach(packageURL -> coordinates.put(packageURL.getType(), packageURL.canonicalize())));
        return coordinates;
    }

    private static void setOverriddenLicense(SW360Release release, Artifact artifact) {
        artifact.askForGet(OverriddenLicenseInformation.class).ifPresent(licenseInformation -> release.setOverriddenLicense(licenseInformation.evaluate()));
    }

    private static void setDeclaredLicense(SW360Release release, Artifact artifact) {
        artifact.askForGet(DeclaredLicenseInformation.class).ifPresent(licenseInformation -> release.setDeclaredLicense(licenseInformation.evaluate()));
    }

    private static void setObservedLicense(SW360Release release, Artifact artifact) {
        artifact.askForGet(ObservedLicenseInformation.class).ifPresent(licenseInformation -> release.setObservedLicense(licenseInformation.evaluate()));
    }

    private static void setSourceUrl(SW360Release release, Artifact artifact) {
        artifact.askForGet(ArtifactSourceUrl.class).ifPresent(arg_0 -> ((SW360Release)release).setDownloadurl(arg_0));
    }

    private static void setReleaseTagUrl(SW360Release release, Artifact artifact) {
        artifact.askForGet(ArtifactReleaseTagURL.class).ifPresent(arg_0 -> ((SW360Release)release).setReleaseTagUrl(arg_0));
    }

    private static void setSwhId(SW360Release release, Artifact artifact) {
        artifact.askForGet(ArtifactSoftwareHeritageID.class).ifPresent(arg_0 -> ((SW360Release)release).setSoftwareHeritageId(arg_0));
    }

    private static void setHashes(SW360Release release, Artifact artifact) {
        Set hashList = artifact.askForAll(ArtifactFilename.class).stream().map(ArtifactFilename::getArtifactFilenameEntries).flatMap(Collection::stream).map(ArtifactFilename.ArtifactFilenameEntry::getHash).collect(Collectors.toSet());
        release.setHashes(hashList);
    }

    private static void setClearingStatus(SW360Release release, Artifact artifact) {
        Optional cs = artifact.askForGet(ArtifactClearingState.class);
        cs.ifPresent(clearingState -> release.setClearingState(clearingState.toString()));
    }

    private static void setChangeStatus(SW360Release release, Artifact artifact) {
        Optional cs = artifact.askForGet(ArtifactChangeStatus.class);
        cs.ifPresent(changeStatus -> release.setChangeStatus(changeStatus.toString()));
    }

    private static void setCopyrights(SW360Release release, Artifact artifact) {
        Optional cs = artifact.askFor(CopyrightStatement.class);
        cs.ifPresent(copyrightStatement -> release.setCopyrights(copyrightStatement.toString()));
    }
}

