/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.sw360.client.SW360ConnectionFactory;
import org.eclipse.sw360.antenna.sw360.client.api.SW360Connection;
import org.eclipse.sw360.antenna.sw360.client.config.SW360ClientConfig;

public class SW360ConnectionConfigurationFactory {
    public static final String REST_SERVER_URL_KEY = "rest.server.url";
    public static final String AUTH_SERVER_URL_KEY = "auth.server.url";
    public static final String USERNAME_KEY = "user.id";
    public static final String PASSWORD_KEY = "user.password";
    public static final String CLIENT_USER_KEY = "client.id";
    public static final String CLIENT_PASSWORD_KEY = "client.password";
    private final SW360ConnectionFactory connectionFactory;

    public SW360ConnectionConfigurationFactory() {
        this(new SW360ConnectionFactory());
    }

    SW360ConnectionConfigurationFactory(SW360ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public SW360Connection createConnection(Getter<String> getConfigValue, HttpClient httpClient, ObjectMapper mapper) {
        String restUrl = getConfigValue.apply(REST_SERVER_URL_KEY);
        String authUrl = getConfigValue.apply(AUTH_SERVER_URL_KEY);
        String user = getConfigValue.apply(USERNAME_KEY);
        String password = getConfigValue.apply(PASSWORD_KEY);
        String clientId = getConfigValue.apply(CLIENT_USER_KEY);
        String clientPassword = getConfigValue.apply(CLIENT_PASSWORD_KEY);
        SW360ClientConfig clientConfig = SW360ClientConfig.createConfig((String)restUrl, (String)authUrl, (String)user, (String)password, (String)clientId, (String)clientPassword, (HttpClient)httpClient, (ObjectMapper)mapper);
        return this.connectionFactory.newConnection(clientConfig);
    }

    SW360ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @FunctionalInterface
    public static interface Getter<T> {
        public T apply(String var1);
    }
}

