/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.generators;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.util.ArtifactLicenseUtils;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataUpdater;
import org.eclipse.sw360.antenna.sw360.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.rest.resource.releases.SW360ReleaseLinkObjects;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToAttachmentUtils;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToReleaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360UpdaterImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360UpdaterImpl.class);
    private final String projectName;
    private final String projectVersion;
    private final SW360MetaDataUpdater sw360MetaDataUpdater;

    public SW360UpdaterImpl(SW360MetaDataUpdater sw360MetaDataUpdater, String projectName, String projectVersion) {
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.sw360MetaDataUpdater = sw360MetaDataUpdater;
    }

    public Map<String, IAttachable> produce(Collection<Artifact> intermediates) {
        ArrayList<SW360Release> releases = new ArrayList<SW360Release>();
        for (Artifact artifact : intermediates) {
            try {
                SW360Release sw360ReleaseFinal = this.artifactToReleaseInSW360(artifact);
                releases.add(sw360ReleaseFinal);
            }
            catch (ExecutionException e) {
                LOGGER.error("Release will not be created in SW360. Reason: {}", (Object)e.getMessage());
                LOGGER.debug("Error: ", (Throwable)e);
            }
        }
        this.sw360MetaDataUpdater.createProject(this.projectName, this.projectVersion, releases);
        return Collections.emptyMap();
    }

    public SW360Release artifactToReleaseInSW360(Artifact artifact) {
        Set<String> licenseIds = this.getSetOfLicenseIds(artifact);
        SW360Release sw360ReleaseFromArtifact = ArtifactToReleaseUtils.convertToReleaseWithoutAttachments(artifact);
        sw360ReleaseFromArtifact.setMainLicenseIds(licenseIds);
        SW360Release sw360ReleaseFinal = this.sw360MetaDataUpdater.getOrCreateRelease(sw360ReleaseFromArtifact);
        sw360ReleaseFinal = this.handleSources(sw360ReleaseFinal, artifact);
        return sw360ReleaseFinal;
    }

    public SW360Release handleSources(SW360Release release, Artifact artifact) {
        Map<Path, SW360AttachmentType> attachments;
        if (this.sw360MetaDataUpdater.isUploadSources() && ((SW360ReleaseLinkObjects)release.get_Links()).getSelf() != null && !((SW360ReleaseLinkObjects)release.get_Links()).getSelf().getHref().isEmpty() && !(attachments = ArtifactToAttachmentUtils.getAttachmentsFromArtifact(artifact)).isEmpty()) {
            release = this.sw360MetaDataUpdater.uploadAttachments(release, attachments);
        }
        return release;
    }

    private Set<String> getSetOfLicenseIds(Artifact artifact) {
        Collection availableLicenses = ArtifactLicenseUtils.getFinalLicenses((Artifact)artifact).getLicenses();
        Set<SW360License> detectedLicenses = this.sw360MetaDataUpdater.getLicenses(availableLicenses);
        Set<String> licenseIds = Collections.emptySet();
        if (detectedLicenses.size() == availableLicenses.size()) {
            licenseIds = detectedLicenses.stream().map(SW360License::getShortName).collect(Collectors.toSet());
        }
        return licenseIds;
    }
}

