/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadResult;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360Visibility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360ProjectType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360MetaDataUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360MetaDataUpdater.class);
    private final SW360ProjectClientAdapter projectClientAdapter;
    private final SW360LicenseClientAdapter licenseClientAdapter;
    private final SW360ReleaseClientAdapter releaseClientAdapter;
    private final boolean updateReleases;
    private final boolean uploadSources;

    public SW360MetaDataUpdater(SW360Connection connection, boolean updateReleases, boolean uploadSources) {
        this.projectClientAdapter = connection.getProjectAdapter();
        this.licenseClientAdapter = connection.getLicenseAdapter();
        this.releaseClientAdapter = connection.getReleaseAdapter();
        this.updateReleases = updateReleases;
        this.uploadSources = uploadSources;
    }

    public Set<SW360License> getLicenses(Collection<License> licenses) {
        return licenses.stream().filter(this::isLicenseInSW360).map(license -> this.licenseClientAdapter.getSW360LicenseByAntennaLicense(license.getId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private boolean isLicenseInSW360(License license) {
        if (this.licenseClientAdapter.isLicenseOfArtifactAvailable(license.getId())) {
            LOGGER.debug("License [{}] found in SW360.", (Object)license.getId());
            return true;
        }
        LOGGER.debug("License [{}] unknown in SW360.", (Object)license.getId());
        return false;
    }

    public SW360Release getOrCreateRelease(SW360Release sw360ReleaseFromArtifact) {
        Optional optSparseReleaseByIds = this.releaseClientAdapter.getSparseReleaseByExternalIds(sw360ReleaseFromArtifact.getExternalIds());
        Optional optSparseRelease = optSparseReleaseByIds.isPresent() ? optSparseReleaseByIds : this.releaseClientAdapter.getSparseReleaseByNameAndVersion(sw360ReleaseFromArtifact.getName(), sw360ReleaseFromArtifact.getVersion());
        Optional<SW360Release> optRelease = optSparseRelease.flatMap(arg_0 -> ((SW360ReleaseClientAdapter)this.releaseClientAdapter).enrichSparseRelease(arg_0)).map(arg_0 -> ((SW360Release)sw360ReleaseFromArtifact).mergeWith(arg_0));
        if (optRelease.isPresent()) {
            SW360Release release = optRelease.get();
            return this.updateReleases ? this.releaseClientAdapter.updateRelease(release) : release;
        }
        return this.releaseClientAdapter.createRelease(sw360ReleaseFromArtifact);
    }

    public void createProject(String projectName, String projectVersion, Collection<SW360Release> releases) {
        Optional<String> projectId = this.projectClientAdapter.getProjectByNameAndVersion(projectName, projectVersion).map(SW360HalResource::getId);
        String id = projectId.orElseGet(() -> this.projectClientAdapter.createProject(SW360MetaDataUpdater.prepareNewProject(projectName, projectVersion)).getId());
        this.projectClientAdapter.addSW360ReleasesToSW360Project(id, releases);
    }

    public boolean isUploadSources() {
        return this.uploadSources;
    }

    public SW360Release uploadAttachments(SW360Release sw360Release, Map<Path, SW360AttachmentType> attachments) {
        AttachmentUploadRequest.Builder builder = AttachmentUploadRequest.builder((SW360HalResource)sw360Release);
        for (Map.Entry<Path, SW360AttachmentType> e : attachments.entrySet()) {
            builder = builder.addAttachment(e.getKey(), e.getValue());
        }
        AttachmentUploadResult result = this.releaseClientAdapter.uploadAttachments(builder.build());
        LOGGER.debug("Result of attachment upload operation: {}", (Object)result);
        if (!result.isSuccess()) {
            LOGGER.error("Failed to upload attachments: {}", (Object)result.failedUploads());
        }
        return (SW360Release)result.getTarget();
    }

    private static SW360Project prepareNewProject(String projectName, String projectVersion) {
        SW360Project sw360Project = new SW360Project();
        sw360Project.setName(projectName);
        sw360Project.setVersion(projectVersion);
        sw360Project.setDescription(projectName + " " + projectVersion);
        sw360Project.setProjectType(SW360ProjectType.PRODUCT);
        sw360Project.setVisibility(SW360Visibility.BUISNESSUNIT_AND_MODERATORS);
        return sw360Project;
    }
}

