/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.utils;

import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFilename;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ComponentAdapterUtils;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.components.SW360Component;

public class ArtifactToComponentUtils {
    private ArtifactToComponentUtils() {
    }

    public static String createComponentName(Artifact artifact) {
        return artifact.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getMainCoordinate).map(ArtifactToComponentUtils::createNameForCoordinate).orElseGet(() -> artifact.askFor(ArtifactFilename.class).flatMap(ArtifactFilename::getBestFilenameEntryGuess).map(ArtifactFilename.ArtifactFilenameEntry::getFilename).orElseThrow(() -> new ExecutionException("Artifact " + artifact.prettyPrint() + " does not have enough facts to create a component name. Please provide more information by an analyzer (" + artifact.getAnalysisSource() + ")")));
    }

    private static String createNameForCoordinate(Coordinate coordinate) {
        if (coordinate.hasNamespace()) {
            return coordinate.getNamespace() + "/" + coordinate.getName();
        }
        return coordinate.getName();
    }

    public static String createComponentVersion(Artifact artifact) {
        return artifact.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getMainCoordinate).map(PackageURLFacade::getVersion).orElse("-");
    }

    public static void setName(SW360Component component, Artifact artifact) {
        component.setName(ArtifactToComponentUtils.createComponentName(artifact));
    }

    private static void setComponentType(SW360Component component, Artifact artifact) {
        SW360ComponentAdapterUtils.setComponentType((SW360Component)component, (boolean)artifact.isProprietary());
    }

    public static void prepareComponent(SW360Component component, Artifact artifact) {
        ArtifactToComponentUtils.setName(component, artifact);
        ArtifactToComponentUtils.setComponentType(component, artifact);
    }
}

